/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining.associationrules;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.AbstractFrequentItemsetAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.FPGrowth;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.associationrules.AssociationRule;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.associationrules.interest.Confidence;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.associationrules.interest.InterestingnessMeasure;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.AssociationRuleResult;
import de.lmu.ifi.dbs.elki.result.FrequentItemsetsResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.IntegerArray;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Reference(authors="M. J. Zaki, W. Meira Jr.", title="Data mining and analysis: fundamental concepts and algorithms", booktitle="Cambridge University Press, 2014", bibkey="DBLP:books/cu/ZM2014")
public class AssociationRuleGeneration
extends AbstractAlgorithm<AssociationRuleResult> {
    private static final Logging LOG = Logging.getLogger(AssociationRuleGeneration.class);
    protected AbstractFrequentItemsetAlgorithm frequentItemAlgo;
    protected InterestingnessMeasure interestingness;
    protected double minmeasure = Double.MIN_VALUE;
    protected double maxmeasure = Double.MAX_VALUE;

    public AssociationRuleGeneration(AbstractFrequentItemsetAlgorithm frequentItemAlgo, InterestingnessMeasure interestMeasure, double minmeasure, double maxmeasure) {
        this.frequentItemAlgo = frequentItemAlgo;
        this.interestingness = interestMeasure;
        this.minmeasure = minmeasure;
        this.maxmeasure = maxmeasure;
    }

    public AssociationRuleGeneration(AbstractFrequentItemsetAlgorithm frequentItemAlgo, InterestingnessMeasure interestMeasure, double minmeasure) {
        this(frequentItemAlgo, interestMeasure, minmeasure, Double.POSITIVE_INFINITY);
    }

    @Override
    public AssociationRuleResult run(Database database) {
        return new Instance().run((FrequentItemsetsResult)this.frequentItemAlgo.run(database));
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.frequentItemAlgo.getInputTypeRestriction();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FREQUENTITEMALGO_ID = new OptionID("associationrules.algorithm", "Algorithm to be used for frequent itemset mining.");
        public static final OptionID INTERESTMEASURE_ID = new OptionID("associationrules.interestingness", "Interestingness measure to be used");
        public static final OptionID MINMEASURE_ID = new OptionID("associationrules.minmeasure", "Minimum threshold for specified interstingness measure");
        public static final OptionID MAXMEASURE_ID = new OptionID("associationrules.maxmeasure", "Maximum threshold for specified interstingness measure");
        protected AbstractFrequentItemsetAlgorithm frequentItemAlgo;
        protected InterestingnessMeasure interestMeasure;
        protected double minmeasure = Double.MIN_VALUE;
        protected double maxmeasure = Double.MAX_VALUE;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter maxmeasureP;
            DoubleParameter minmeasureP;
            ObjectParameter interestMeasureP;
            super.makeOptions(config);
            ObjectParameter frequentItemAlgoP = new ObjectParameter(FREQUENTITEMALGO_ID, (Class<?>)AbstractFrequentItemsetAlgorithm.class, FPGrowth.class);
            if (config.grab(frequentItemAlgoP)) {
                this.frequentItemAlgo = (AbstractFrequentItemsetAlgorithm)frequentItemAlgoP.instantiateClass(config);
            }
            if (config.grab(interestMeasureP = new ObjectParameter(INTERESTMEASURE_ID, (Class<?>)InterestingnessMeasure.class, Confidence.class))) {
                this.interestMeasure = (InterestingnessMeasure)interestMeasureP.instantiateClass(config);
            }
            if (config.grab(minmeasureP = new DoubleParameter(MINMEASURE_ID))) {
                this.minmeasure = (Double)minmeasureP.getValue();
            }
            if (config.grab(maxmeasureP = (DoubleParameter)new DoubleParameter(MAXMEASURE_ID).setOptional(true))) {
                this.maxmeasure = (Double)maxmeasureP.getValue();
            }
        }

        @Override
        protected AssociationRuleGeneration makeInstance() {
            return new AssociationRuleGeneration(this.frequentItemAlgo, this.interestMeasure, this.minmeasure, this.maxmeasure);
        }
    }

    public static class ItemsetSearcher {
        List<Itemset> itemsets;
        IntegerArray offsets;

        public ItemsetSearcher(List<Itemset> itemsets) {
            this.itemsets = itemsets;
            this.offsets = new IntegerArray();
            this.offsets.add(0);
            this.offsets.add(0);
            this.buildIndex(0, itemsets.size());
            this.offsets.add(itemsets.size());
        }

        public Itemset search(Itemset c) {
            int l = c.length();
            int lp1 = l + 1;
            if (l == 0 || lp1 >= this.offsets.size()) {
                return null;
            }
            int b = this.offsets.get(l);
            int e = this.offsets.get(lp1);
            while (b < e) {
                int m = b + e >>> 1;
                Itemset mi = this.itemsets.get(m);
                int cmp = c.compareTo(mi);
                if (cmp == 0) {
                    return mi;
                }
                if (cmp < 0) {
                    e = m;
                    continue;
                }
                b = m + 1;
            }
            return null;
        }

        public int maxLength() {
            return this.itemsets.size() - 1;
        }

        public int getOffset(int i) {
            return this.offsets.get(i);
        }

        private void buildIndex(int begin, int end) {
            while (begin < end) {
                int half = begin + end >>> 1;
                int len = this.itemsets.get(half).length();
                if (begin == half) {
                    assert (begin + 1 == end);
                    while (len >= this.offsets.size) {
                        this.offsets.add(begin);
                    }
                    return;
                }
                if (len >= this.offsets.size) {
                    this.buildIndex(begin, half);
                }
                begin = half;
            }
        }
    }

    protected static class PartialItemset
    extends Itemset {
        public int len;
        public int begin;
        public int[] indices;

        public PartialItemset(int[] indices) {
            this.indices = indices;
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public int iter() {
            return 0;
        }

        @Override
        public boolean iterValid(int iter) {
            return iter < this.len;
        }

        @Override
        public int iterAdvance(int iter) {
            return ++iter;
        }

        @Override
        public int iterDim(int iter) {
            return this.indices[this.begin + iter];
        }
    }

    public class Instance {
        private int totalTransactions;
        private PartialItemset scratch1;
        private PartialItemset scratch2;
        private ArrayList<AssociationRule> rules;
        private ItemsetSearcher searcher;
        private VectorFieldTypeInformation<BitVector> meta;

        public AssociationRuleResult run(FrequentItemsetsResult frequentResult) {
            ArrayList<Itemset> itemsets = frequentResult.getItemsets();
            if (itemsets.isEmpty()) {
                LOG.warning("No frequent itemsets found.");
                return new AssociationRuleResult("association rules", "arules", Collections.emptyList(), frequentResult.getMeta());
            }
            itemsets = itemsets instanceof ArrayList ? itemsets : new ArrayList<Itemset>(itemsets);
            this.meta = frequentResult.getMeta();
            int maxlen = ((Itemset)itemsets.get(itemsets.size() - 1)).length();
            this.totalTransactions = frequentResult.getTotal();
            this.rules = new ArrayList();
            this.searcher = new ItemsetSearcher(itemsets);
            int[] ind = new int[maxlen];
            Arrays.fill(ind, -1);
            this.scratch1 = new PartialItemset(ind);
            this.scratch2 = new PartialItemset(ind);
            int e = itemsets.size();
            for (int i = this.searcher.getOffset(2); i < e && i >= 0; ++i) {
                Itemset itemset = (Itemset)itemsets.get(i);
                int len = itemset.length();
                assert (len > 1);
                if (LOG.isDebuggingFine()) {
                    LOG.fine("Searching for rules based on: " + itemset);
                }
                int it = itemset.iter();
                int j = 0;
                while (itemset.iterValid(it)) {
                    ind[j] = itemset.iterDim(it);
                    it = itemset.iterAdvance(it);
                    ++j;
                }
                this.scratch1.begin = 0;
                this.scratch1.len = len;
                this.scratch2.begin = len;
                this.scratch2.len = 0;
                this.processSubsets(itemset, len, len - 1);
            }
            return new AssociationRuleResult("association rules", "arules", this.rules, this.meta);
        }

        private void processSubsets(Itemset itemset, int len, int cur) {
            while (cur >= 0 && this.scratch1.len > 1) {
                assert (cur < this.scratch1.len);
                int[] indices = this.scratch1.indices;
                int elemMoved = indices[cur];
                System.arraycopy(indices, cur + 1, indices, cur, this.scratch1.len - cur - 1);
                --this.scratch1.len;
                ++this.scratch2.len;
                --this.scratch2.begin;
                indices[this.scratch1.len] = elemMoved;
                Itemset antecedent = this.searcher.search(this.scratch1);
                Itemset consequent = this.searcher.search(this.scratch2);
                if (antecedent == null) {
                    LOG.warning(this.scratch1.appendItemsTo(new StringBuilder(100).append("Antecedent not found: "), this.meta));
                }
                if (consequent == null) {
                    LOG.warning(this.scratch2.appendItemsTo(new StringBuilder(100).append("Consequent not found: "), this.meta));
                }
                boolean prune = false;
                if (antecedent != null && consequent != null) {
                    double measure = AssociationRuleGeneration.this.interestingness.measure(this.totalTransactions, antecedent.getSupport(), consequent.getSupport(), itemset.getSupport());
                    if (measure >= AssociationRuleGeneration.this.minmeasure && measure <= AssociationRuleGeneration.this.maxmeasure) {
                        this.rules.add(new AssociationRule(itemset, consequent, antecedent, measure));
                    } else if (AssociationRuleGeneration.this.interestingness instanceof Confidence) {
                        prune = true;
                    }
                }
                if (!prune) {
                    this.processSubsets(itemset, len, cur - 1);
                }
                ++this.scratch1.len;
                --this.scratch2.len;
                ++this.scratch2.begin;
                System.arraycopy(indices, cur, indices, cur + 1, this.scratch1.len - cur - 1);
                indices[cur] = elemMoved;
                --cur;
            }
        }
    }
}

