/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LUDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import net.jafama.FastMath;

@Title(value="Gaussian Model Outlier Detection")
@Description(value="Fit a multivariate gaussian model onto the data, and use the PDF to compute an outlier score.")
public class GaussianModel<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(GaussianModel.class);
    private boolean invert = false;

    public GaussianModel(boolean invert) {
        this.invert = invert;
    }

    public OutlierResult run(Relation<V> relation) {
        BasicOutlierScoreMeta meta;
        DoubleMinMax mm = new DoubleMinMax();
        WritableDoubleDataStore oscores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        CovarianceMatrix temp = CovarianceMatrix.make(relation);
        double[] mean = temp.getMeanVector(relation).toArray();
        double[][] covarianceMatrix = temp.destroyToPopulationMatrix();
        double[][] covarianceTransposed = VMath.inverse(covarianceMatrix);
        double det = new LUDecomposition(covarianceMatrix).det();
        double fakt = 1.0 / FastMath.sqrt(MathUtil.powi(Math.PI * 2, RelationUtil.dimensionality(relation)) * det);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double[] x = VMath.minusEquals(((NumberVector)relation.get(iditer)).toArray(), mean);
            double mDist = VMath.transposeTimesTimes(x, covarianceTransposed, x);
            double prob = fakt * FastMath.exp(-mDist * 0.5);
            mm.put(prob);
            oscores.putDouble(iditer, prob);
            iditer.advance();
        }
        if (this.invert) {
            double max = mm.getMax() != 0.0 ? mm.getMax() : 1.0;
            DBIDIter iditer2 = relation.iterDBIDs();
            while (iditer2.valid()) {
                oscores.putDouble(iditer2, (max - oscores.doubleValue(iditer2)) / max);
                iditer2.advance();
            }
            meta = new BasicOutlierScoreMeta(0.0, 1.0);
        } else {
            meta = new InvertedOutlierScoreMeta(mm.getMin(), mm.getMax(), 0.0, Double.POSITIVE_INFINITY);
        }
        MaterializedDoubleRelation res = new MaterializedDoubleRelation("Gaussian Model Outlier Score", "gaussian-model-outlier", oscores, relation.getDBIDs());
        return new OutlierResult(meta, res);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID INVERT_ID = new OptionID("gaussod.invert", "Invert the value range to [0:1], with 1 being outliers instead of 0.");
        protected boolean invert = false;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            Flag flag = new Flag(INVERT_ID);
            if (config.grab(flag)) {
                this.invert = (Boolean)flag.getValue();
            }
        }

        @Override
        protected GaussianModel<V> makeInstance() {
            return new GaussianModel(this.invert);
        }
    }
}

