/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.LUDecomposition;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import net.jafama.FastMath;

@Title(value="Gaussian-Uniform Mixture Model Outlier Detection")
@Description(value="Fits a mixture model consisting of a Gaussian and a uniform distribution to the data.")
@Reference(prefix="Generalization using the likelihood gain as outlier score of", authors="E. Eskin", title="Anomaly detection over noisy data using learned probability distributions", booktitle="Proc. 17th Int. Conf. on Machine Learning (ICML-2000)", url="https://doi.org/10.7916/D8C53SKF", bibkey="DBLP:conf/icml/Eskin00")
public class GaussianUniformMixture<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(GaussianUniformMixture.class);
    private static final int MAX_ITER = 10;
    private double c;
    private double logl;
    private double logml;

    public GaussianUniformMixture(double l, double c) {
        this.logl = FastMath.log(l);
        this.logml = FastMath.log(1.0 - l);
        this.c = c;
    }

    public OutlierResult run(Relation<V> relation) {
        ArrayDBIDs objids = DBIDUtil.ensureArray(relation.getDBIDs());
        CovarianceMatrix builder = CovarianceMatrix.make(relation, objids);
        HashSetModifiableDBIDs anomalous = DBIDUtil.newHashSet();
        WritableDoubleDataStore oscores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        double logLike = (double)objids.size() * this.logml + this.loglikelihoodNormal(objids, anomalous, builder, relation);
        DoubleMinMax minmax = new DoubleMinMax();
        for (int loop = 0; loop < 10; ++loop) {
            boolean changed = false;
            DBIDArrayIter iter = objids.iter();
            while (iter.valid()) {
                boolean wasadded = anomalous.add(iter) || !anomalous.remove(iter);
                NumberVector vec = (NumberVector)relation.get(iter);
                builder.put(vec, wasadded ? -1.0 : 1.0);
                double currentLogLike = (double)(objids.size() - anomalous.size()) * this.logml + this.loglikelihoodNormal(objids, anomalous, builder, relation) + (double)anomalous.size() * this.logl + this.loglikelihoodAnomalous(anomalous);
                double loglikeGain = currentLogLike - logLike;
                oscores.putDouble(iter, loglikeGain);
                minmax.put(loglikeGain);
                if (loglikeGain > this.c) {
                    logLike = currentLogLike;
                    changed = true;
                } else {
                    wasadded = wasadded ? anomalous.remove(iter) : !anomalous.add(iter);
                    builder.put(vec, wasadded ? 1.0 : -1.0);
                }
                iter.advance();
            }
            assert ((long)anomalous.size() == Math.round((double)objids.size() - builder.getWeight()));
            if (!changed) break;
        }
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        MaterializedDoubleRelation res = new MaterializedDoubleRelation("Gaussian Mixture Outlier Score", "gaussian-mixture-outlier", oscores, relation.getDBIDs());
        return new OutlierResult(meta, res);
    }

    private double loglikelihoodAnomalous(DBIDs anomalousObjs) {
        return anomalousObjs.isEmpty() ? 0.0 : (double)anomalousObjs.size() * -FastMath.log(anomalousObjs.size());
    }

    private double loglikelihoodNormal(DBIDs objids, SetDBIDs anomalous, CovarianceMatrix builder, Relation<V> relation) {
        double[] mean = builder.getMeanVector();
        LUDecomposition lu = new LUDecomposition(builder.makeSampleMatrix());
        double[][] covInv = lu.inverse();
        double prob = (double)(objids.size() - anomalous.size()) * -FastMath.log(FastMath.sqrt(MathUtil.powi(Math.PI * 2, RelationUtil.dimensionality(relation)) * lu.det()));
        DBIDIter iter = objids.iter();
        while (iter.valid()) {
            if (!anomalous.contains(iter)) {
                double[] xcent = VMath.minusEquals(((NumberVector)relation.get(iter)).toArray(), mean);
                prob -= 0.5 * VMath.transposeTimesTimes(xcent, covInv, xcent);
            }
            iter.advance();
        }
        return prob;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID L_ID = new OptionID("mmo.l", "expected fraction of outliers");
        public static final OptionID C_ID = new OptionID("mmo.c", "cutoff");
        protected double l = 1.0E-7;
        protected double c = 0.0;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter cP;
            super.makeOptions(config);
            DoubleParameter lP = new DoubleParameter(C_ID, 1.0E-7);
            if (config.grab(lP)) {
                this.l = (Double)lP.getValue();
            }
            if (config.grab(cP = new DoubleParameter(C_ID, 1.0E-7))) {
                this.c = (Double)cP.getValue();
            }
        }

        @Override
        protected GaussianUniformMixture<V> makeInstance() {
            return new GaussianUniformMixture(this.l, this.c);
        }
    }
}

