/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.AbstractOPTICS;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.List;

@Title(value="OPTICS-OF: Identifying Local Outliers")
@Description(value="Algorithm to compute density-based local outlier factors in a database based on the neighborhood size parameter 'minpts'")
@Reference(authors="Markus M. Breunig, Hans-Peter Kriegel, Raymond Ng, J\u00f6rg Sander", title="OPTICS-OF: Identifying Local Outliers", booktitle="Proc. 3rd European Conf. on Principles of Knowledge Discovery and Data Mining (PKDD'99)", url="https://doi.org/10.1007/978-3-540-48247-5_28", bibkey="DBLP:conf/pkdd/BreunigKNS99")
public class OPTICSOF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(OPTICSOF.class);
    private int minpts;

    public OPTICSOF(DistanceFunction<? super O> distanceFunction, int minpts) {
        super(distanceFunction);
        this.minpts = minpts;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnQuery = database.getKNNQuery(distQuery, this.minpts);
        RangeQuery<O> rangeQuery = database.getRangeQuery(distQuery, new Object[0]);
        DBIDs ids = relation.getDBIDs();
        WritableDataStore<KNNList> nMinPts = DataStoreUtil.makeStorage(ids, 3, KNNList.class);
        WritableDoubleDataStore coreDistance = DataStoreUtil.makeDoubleStorage(ids, 3);
        WritableIntegerDataStore minPtsNeighborhoodSize = DataStoreUtil.makeIntegerStorage(ids, 3, -1);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList minptsNeighbours = knnQuery.getKNNForDBID(iditer, this.minpts);
            double d = minptsNeighbours.getKNNDistance();
            nMinPts.put(iditer, minptsNeighbours);
            coreDistance.putDouble(iditer, d);
            minPtsNeighborhoodSize.put((DBIDRef)iditer, rangeQuery.getRangeForDBID(iditer, d).size());
            iditer.advance();
        }
        WritableDataStore<List> reachDistance = DataStoreUtil.makeStorage(ids, 3, List.class);
        WritableDoubleDataStore lrds = DataStoreUtil.makeDoubleStorage(ids, 3);
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            ArrayList<Double> core = new ArrayList<Double>();
            double lrd = 0.0;
            DoubleDBIDListIter neighbor = ((KNNList)nMinPts.get(iditer2)).iter();
            while (neighbor.valid()) {
                double coreDist = coreDistance.doubleValue(neighbor);
                double dist = distQuery.distance((DBIDRef)iditer2, (DBIDRef)neighbor);
                double rd = MathUtil.max(coreDist, dist);
                lrd = rd + lrd;
                core.add(rd);
                neighbor.advance();
            }
            lrd = (double)minPtsNeighborhoodSize.intValue(iditer2) / lrd;
            reachDistance.put(iditer2, core);
            lrds.putDouble(iditer2, lrd);
            iditer2.advance();
        }
        DoubleMinMax ofminmax = new DoubleMinMax();
        WritableDoubleDataStore ofs = DataStoreUtil.makeDoubleStorage(ids, 4);
        DBIDIter iditer3 = relation.iterDBIDs();
        while (iditer3.valid()) {
            double of = 0.0;
            DoubleDBIDListIter neighbor = ((KNNList)nMinPts.get(iditer3)).iter();
            while (neighbor.valid()) {
                double lrd = lrds.doubleValue(iditer3);
                double lrdN = lrds.doubleValue(neighbor);
                of += lrdN / lrd;
                neighbor.advance();
            }
            ofs.putDouble(iditer3, of /= (double)minPtsNeighborhoodSize.intValue(iditer3));
            ofminmax.put(of);
            iditer3.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("OPTICS Outlier Scores", "optics-outlier", ofs, relation.getDBIDs());
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(ofminmax.getMin(), ofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        protected int minpts = 0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter param = (IntParameter)new IntParameter(AbstractOPTICS.Parameterizer.MINPTS_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(param)) {
                this.minpts = (Integer)param.getValue();
            }
        }

        @Override
        protected OPTICSOF<O> makeInstance() {
            return new OPTICSOF(this.distanceFunction, this.minpts);
        }
    }
}

