/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.DependencyDerivator;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.CorrelationAnalysisSolution;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCARunner;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.EigenPairFilter;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.filter.PercentageEigenPairFilter;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Title(value="Simple COP: Correlation Outlier Probability")
@Reference(authors="Arthur Zimek", title="Application 2: Outlier Detection (Chapter 18)", booktitle="Correlation Clustering", bibkey="phd/dnb/Zimek08/Ch18")
public class SimpleCOP<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimpleCOP.class);
    int k;
    private DependencyDerivator<V> dependencyDerivator;

    public SimpleCOP(DistanceFunction<? super V> distanceFunction, int k, PCARunner pca, EigenPairFilter filter) {
        super(distanceFunction);
        this.k = k;
        this.dependencyDerivator = new DependencyDerivator(null, FormatUtil.NF, pca, filter, 0, false);
    }

    public OutlierResult run(Database database, Relation<V> data) throws IllegalStateException {
        KNNQuery<V> knnQuery = QueryUtil.getKNNQuery(data, this.getDistanceFunction(), this.k + 1);
        DBIDs ids = data.getDBIDs();
        WritableDoubleDataStore cop_score = DataStoreUtil.makeDoubleStorage(ids, 6);
        WritableDataStore<double[]> cop_err_v = DataStoreUtil.makeStorage(ids, 6, double[].class);
        WritableDataStore<double[]> cop_datav = DataStoreUtil.makeStorage(ids, 6, double[].class);
        WritableIntegerDataStore cop_dim = DataStoreUtil.makeIntegerStorage(ids, 6, -1);
        WritableDataStore<CorrelationAnalysisSolution> cop_sol = DataStoreUtil.makeStorage(ids, 6, CorrelationAnalysisSolution.class);
        FiniteProgress progressLocalPCA = LOG.isVerbose() ? new FiniteProgress("Correlation Outlier Probabilities", data.size(), LOG) : null;
        double sqrt2 = MathUtil.SQRT2;
        DBIDIter id = data.iterDBIDs();
        while (id.valid()) {
            KNNList neighbors = knnQuery.getKNNForDBID(id, this.k + 1);
            ArrayModifiableDBIDs nids = DBIDUtil.newArray(neighbors);
            nids.remove(id);
            CorrelationAnalysisSolution<NumberVector> depsol = this.dependencyDerivator.generateModel(data, nids);
            double stddev = depsol.getStandardDeviation();
            double distance = FastMath.sqrt(depsol.squaredDistance((NumberVector)data.get(id)));
            double prob = NormalDistribution.erf(distance / (stddev * sqrt2));
            cop_score.putDouble(id, prob);
            cop_err_v.put(id, VMath.times(depsol.errorVector((NumberVector)data.get(id)), -1.0));
            cop_datav.put(id, depsol.dataVector((NumberVector)data.get(id)));
            cop_dim.putInt(id, depsol.getCorrelationDimensionality());
            cop_sol.put(id, depsol);
            LOG.incrementProcessed(progressLocalPCA);
            id.advance();
        }
        LOG.ensureCompleted(progressLocalPCA);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Original Correlation Outlier Probabilities", "origcop-outlier", cop_score, ids);
        ProbabilisticOutlierScore scoreMeta = new ProbabilisticOutlierScore();
        OutlierResult result = new OutlierResult(scoreMeta, scoreResult);
        result.addChildResult(new MaterializedRelation<Integer>("Local Dimensionality", "cop-dim", TypeUtil.INTEGER, cop_dim, ids));
        result.addChildResult(new MaterializedRelation<double[]>("Error vectors", "cop-errorvec", TypeUtil.DOUBLE_ARRAY, cop_err_v, ids));
        result.addChildResult(new MaterializedRelation<double[]>("Data vectors", "cop-datavec", TypeUtil.DOUBLE_ARRAY, cop_datav, ids));
        result.addChildResult(new MaterializedRelation<CorrelationAnalysisSolution>("Correlation analysis", "cop-sol", new SimpleTypeInformation<CorrelationAnalysisSolution>(CorrelationAnalysisSolution.class), cop_sol, ids));
        return result;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID K_ID = new OptionID("cop.k", "The number of nearest neighbors of an object to be considered for computing its COP_SCORE.");
        public static final OptionID PCARUNNER_ID = new OptionID("cop.pcarunner", "The class to compute (filtered) PCA.");
        int k;
        protected PCARunner pca;
        private EigenPairFilter filter;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter filterP;
            ObjectParameter pcaP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
            if (config.grab(pcaP = new ObjectParameter(PCARUNNER_ID, (Class<?>)PCARunner.class, PCARunner.class))) {
                this.pca = (PCARunner)pcaP.instantiateClass(config);
            }
            if (config.grab(filterP = new ObjectParameter(EigenPairFilter.PCA_EIGENPAIR_FILTER, (Class<?>)EigenPairFilter.class, PercentageEigenPairFilter.class))) {
                this.filter = (EigenPairFilter)filterP.instantiateClass(config);
            }
        }

        @Override
        protected SimpleCOP<V> makeInstance() {
            return new SimpleCOP(this.distanceFunction, this.k, this.pca, this.filter);
        }
    }
}

