/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.KernelMatrix;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.PolynomialKernelFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Title(value="ABOD: Angle-Based Outlier Detection")
@Description(value="Outlier detection using variance analysis on angles, especially for high dimensional data sets.")
@Reference(authors="Hans-Peter Kriegel, Matthias Schubert, Arthur Zimek", title="Angle-Based Outlier Detection in High-dimensional Data", booktitle="Proc. 14th ACM SIGKDD Int. Conf. Knowledge Discovery and Data Mining (KDD'08)", url="https://doi.org/10.1145/1401890.1401946", bibkey="DBLP:conf/kdd/KriegelSZ08")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.ABOD", "abod"})
public class ABOD<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ABOD.class);
    protected SimilarityFunction<? super V> kernelFunction;

    public ABOD(SimilarityFunction<? super V> kernelFunction) {
        this.kernelFunction = kernelFunction;
    }

    public OutlierResult run(Database db, Relation<V> relation) {
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        SimilarityQuery<? super V> sq = db.getSimilarityQuery(relation, this.kernelFunction, new Object[0]);
        KernelMatrix kernelMatrix = new KernelMatrix(sq, relation, (DBIDs)ids);
        WritableDoubleDataStore abodvalues = DataStoreUtil.makeDoubleStorage(ids, 4);
        DoubleMinMax minmaxabod = new DoubleMinMax();
        MeanVariance s = new MeanVariance();
        DBIDArrayIter pA = ids.iter();
        DBIDArrayIter pB = ids.iter();
        DBIDArrayIter pC = ids.iter();
        while (pA.valid()) {
            double abof = this.computeABOF(kernelMatrix, pA, pB, pC, s);
            minmaxabod.put(abof);
            abodvalues.putDouble(pA, abof);
            pA.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Angle-Based Outlier Degree", "abod-outlier", abodvalues, relation.getDBIDs());
        InvertedOutlierScoreMeta scoreMeta = new InvertedOutlierScoreMeta(minmaxabod.getMin(), minmaxabod.getMax(), 0.0, Double.POSITIVE_INFINITY);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    protected double computeABOF(KernelMatrix kernelMatrix, DBIDRef pA, DBIDArrayIter pB, DBIDArrayIter pC, MeanVariance s) {
        s.reset();
        double simAA = kernelMatrix.getSimilarity(pA, pA);
        pB.seek(0);
        while (pB.valid()) {
            double simAB;
            double simBB;
            double sqdAB;
            if (!DBIDUtil.equal(pB, pA) && (sqdAB = simAA + (simBB = kernelMatrix.getSimilarity(pB, pB)) - (simAB = kernelMatrix.getSimilarity(pA, pB)) - simAB) > 0.0) {
                pC.seek(pB.getOffset() + 1);
                while (pC.valid()) {
                    double simAC;
                    double simCC;
                    double sqdAC;
                    if (!DBIDUtil.equal(pC, pA) && (sqdAC = simAA + (simCC = kernelMatrix.getSimilarity(pC, pC)) - (simAC = kernelMatrix.getSimilarity(pA, pC)) - simAC) > 0.0) {
                        double simBC = kernelMatrix.getSimilarity(pB, pC);
                        double numerator = simBC - simAB - simAC + simAA;
                        double div = 1.0 / (sqdAB * sqdAC);
                        s.put(numerator * div, FastMath.sqrt(div));
                    }
                    pC.advance();
                }
            }
            pB.advance();
        }
        return s.getNaiveVariance();
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID KERNEL_FUNCTION_ID = new OptionID("abod.kernelfunction", "Kernel function to use.");
        protected SimilarityFunction<V> kernelFunction = null;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            ObjectParameter param = new ObjectParameter(KERNEL_FUNCTION_ID, (Class<?>)SimilarityFunction.class, PolynomialKernelFunction.class);
            if (config.grab(param)) {
                this.kernelFunction = (SimilarityFunction)param.instantiateClass(config);
            }
        }

        @Override
        protected ABOD<V> makeInstance() {
            return new ABOD<V>(this.kernelFunction);
        }
    }
}

