/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased;

import de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased.ABOD;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.KernelMatrix;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.LinearKernelFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import net.jafama.FastMath;

@Title(value="Approximate ABOD: Angle-Based Outlier Detection")
@Description(value="Outlier detection using variance analysis on angles, especially for high dimensional data sets.")
@Reference(authors="Hans-Peter Kriegel, Matthias Schubert, Arthur Zimek", title="Angle-Based Outlier Detection in High-dimensional Data", booktitle="Proc. 14th ACM SIGKDD Int. Conf. Knowledge Discovery and Data Mining (KDD'08)", url="https://doi.org/10.1145/1401890.1401946", bibkey="DBLP:conf/kdd/KriegelSZ08")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.FastABOD", "fastabod"})
public class FastABOD<V extends NumberVector>
extends ABOD<V> {
    private static final Logging LOG = Logging.getLogger(FastABOD.class);
    protected int k;

    public FastABOD(SimilarityFunction<? super V> kernelFunction, int k) {
        super(kernelFunction);
        this.k = k;
    }

    @Override
    public OutlierResult run(Database db, Relation<V> relation) {
        DBIDs ids = relation.getDBIDs();
        WritableDoubleDataStore abodvalues = DataStoreUtil.makeDoubleStorage(ids, 4);
        DoubleMinMax minmaxabod = new DoubleMinMax();
        if (this.kernelFunction.getClass() == LinearKernelFunction.class) {
            if (!this.kNNABOD(db, relation, ids, abodvalues, minmaxabod)) {
                this.fastABOD(db, relation, ids, abodvalues, minmaxabod);
            }
        } else {
            this.fastABOD(db, relation, ids, abodvalues, minmaxabod);
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Angle-Based Outlier Degree", "abod-outlier", abodvalues, relation.getDBIDs());
        InvertedOutlierScoreMeta scoreMeta = new InvertedOutlierScoreMeta(minmaxabod.getMin(), minmaxabod.getMax(), 0.0, Double.POSITIVE_INFINITY);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    private boolean kNNABOD(Database db, Relation<V> relation, DBIDs ids, WritableDoubleDataStore abodvalues, DoubleMinMax minmaxabod) {
        DistanceQuery<NumberVector> dq = db.getDistanceQuery(relation, SquaredEuclideanDistanceFunction.STATIC, new Object[0]);
        KNNQuery<NumberVector> knnq = db.getKNNQuery(dq, "optimized");
        boolean squared = true;
        if (knnq == null) {
            dq = db.getDistanceQuery(relation, EuclideanDistanceFunction.STATIC, new Object[0]);
            knnq = db.getKNNQuery(dq, "optimized");
            if (knnq == null) {
                return false;
            }
            squared = false;
        }
        SimilarityQuery<NumberVector> lk = db.getSimilarityQuery(relation, LinearKernelFunction.STATIC, new Object[0]);
        int k1 = this.k + 1;
        MeanVariance s = new MeanVariance();
        DBIDIter pA = ids.iter();
        while (pA.valid()) {
            KNNList nl = knnq.getKNNForDBID(pA, k1);
            double simAA = lk.similarity((DBIDRef)pA, (DBIDRef)pA);
            s.reset();
            DoubleDBIDListIter iB = nl.iter();
            DoubleDBIDListIter iC = nl.iter();
            while (iB.valid()) {
                double dAB = iB.doubleValue();
                double simAB = lk.similarity((DBIDRef)pA, (DBIDRef)iB);
                if (dAB > 0.0) {
                    iC.seek(iB.getOffset() + 1);
                    while (iC.valid()) {
                        double dAC = iC.doubleValue();
                        double simAC = lk.similarity((DBIDRef)pA, (DBIDRef)iC);
                        if (dAC > 0.0) {
                            double simBC = lk.similarity((DBIDRef)iB, (DBIDRef)iC);
                            double numerator = simBC - simAB - simAC + simAA;
                            if (squared) {
                                double div = 1.0 / (dAB * dAC);
                                s.put(numerator * div, FastMath.sqrt(div));
                            } else {
                                double sqrtdiv = 1.0 / (dAB * dAC);
                                s.put(numerator * sqrtdiv * sqrtdiv, sqrtdiv);
                            }
                        }
                        iC.advance();
                    }
                }
                iB.advance();
            }
            double abof = s.getNaiveVariance();
            minmaxabod.put(abof);
            abodvalues.putDouble(pA, abof);
            pA.advance();
        }
        return true;
    }

    private void fastABOD(Database db, Relation<V> relation, DBIDs ids, WritableDoubleDataStore abodvalues, DoubleMinMax minmaxabod) {
        SimilarityQuery<V> sq = db.getSimilarityQuery(relation, this.kernelFunction, new Object[0]);
        KernelMatrix kernelMatrix = new KernelMatrix(sq, relation, ids);
        MeanVariance s = new MeanVariance();
        KNNHeap nn = DBIDUtil.newHeap(this.k);
        DBIDIter pA = ids.iter();
        while (pA.valid()) {
            double simAA = kernelMatrix.getSimilarity(pA, pA);
            nn.clear();
            DBIDIter nB = relation.iterDBIDs();
            while (nB.valid()) {
                double simAB;
                double simBB;
                double sqdAB;
                if (!DBIDUtil.equal(nB, pA) && (sqdAB = simAA + (simBB = kernelMatrix.getSimilarity(nB, nB)) - (simAB = kernelMatrix.getSimilarity(pA, nB)) - simAB) > 0.0) {
                    nn.insert(sqdAB, nB);
                }
                nB.advance();
            }
            KNNList nl = nn.toKNNList();
            s.reset();
            DoubleDBIDListIter iB = nl.iter();
            DoubleDBIDListIter iC = nl.iter();
            while (iB.valid()) {
                double sqdAB = iB.doubleValue();
                double simAB = kernelMatrix.getSimilarity(pA, iB);
                if (sqdAB > 0.0) {
                    iC.seek(iB.getOffset() + 1);
                    while (iC.valid()) {
                        double sqdAC = iC.doubleValue();
                        double simAC = kernelMatrix.getSimilarity(pA, iC);
                        if (sqdAC > 0.0) {
                            double simBC = kernelMatrix.getSimilarity(iB, iC);
                            double numerator = simBC - simAB - simAC + simAA;
                            double div = 1.0 / (sqdAB * sqdAC);
                            s.put(numerator * div, FastMath.sqrt(div));
                        }
                        iC.advance();
                    }
                }
                iB.advance();
            }
            double abof = s.getNaiveVariance();
            minmaxabod.put(abof);
            abodvalues.putDouble(pA, abof);
            pA.advance();
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends ABOD.Parameterizer<V> {
        public static final OptionID K_ID = new OptionID("fastabod.k", "Number of nearest neighbors to use for ABOD.");
        protected int k;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)new GreaterEqualConstraint(3));
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
        }

        @Override
        protected FastABOD<V> makeInstance() {
            return new FastABOD(this.kernelFunction, this.k);
        }
    }
}

