/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased;

import de.lmu.ifi.dbs.elki.algorithm.outlier.anglebased.FastABOD;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.kernel.KernelMatrix;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMinHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import net.jafama.FastMath;

@Title(value="LB-ABOD: Lower Bounded Angle-Based Outlier Detection")
@Description(value="Outlier detection using variance analysis on angles, especially for high dimensional data sets.")
@Reference(authors="Hans-Peter Kriegel, Matthias Schubert, Arthur Zimek", title="Angle-Based Outlier Detection in High-dimensional Data", booktitle="Proc. 14th ACM SIGKDD Int. Conf. Knowledge Discovery and Data Mining (KDD'08)", url="https://doi.org/10.1145/1401890.1401946", bibkey="DBLP:conf/kdd/KriegelSZ08")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.LBABOD", "lb-abod"})
public class LBABOD<V extends NumberVector>
extends FastABOD<V> {
    private static final Logging LOG = Logging.getLogger(LBABOD.class);
    protected int l;

    public LBABOD(SimilarityFunction<? super V> kernelFunction, int k, int l) {
        super(kernelFunction, k);
        this.l = l;
    }

    @Override
    public OutlierResult run(Database db, Relation<V> relation) {
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        DBIDArrayIter pB = ids.iter();
        DBIDArrayIter pC = ids.iter();
        SimilarityQuery<V> sq = db.getSimilarityQuery(relation, this.kernelFunction, new Object[0]);
        KernelMatrix kernelMatrix = new KernelMatrix(sq, relation, (DBIDs)ids);
        WritableDoubleDataStore abodvalues = DataStoreUtil.makeDoubleStorage(ids, 4);
        DoubleMinMax minmaxabod = new DoubleMinMax();
        double max = 0.0;
        WritableDoubleDataStore sqDists = DataStoreUtil.makeDoubleStorage(ids, 3);
        KNNHeap nn = DBIDUtil.newHeap(this.k);
        ModifiableDoubleDBIDList candidates = DBIDUtil.newDistanceDBIDList(relation.size());
        DBIDIter pA = relation.iterDBIDs();
        while (pA.valid()) {
            nn.clear();
            double simAA = kernelMatrix.getSimilarity(pA, pA);
            double sumid = 0.0;
            double sumisqd = 0.0;
            pB.seek(0);
            while (pB.valid()) {
                if (!DBIDUtil.equal(pB, pA)) {
                    double simBB = kernelMatrix.getSimilarity(pB, pB);
                    double simAB = kernelMatrix.getSimilarity(pA, pB);
                    double sqdAB = simAA + simBB - simAB - simAB;
                    sqDists.putDouble(pB, sqdAB);
                    double isqdAB = 1.0 / sqdAB;
                    sumid += FastMath.sqrt(isqdAB);
                    sumisqd += isqdAB;
                    nn.insert(sqdAB, pB);
                }
                pB.advance();
            }
            double nnsum = 0.0;
            double nnsumsq = 0.0;
            double nnsumisqd = 0.0;
            KNNList nl = nn.toKNNList();
            DoubleDBIDListIter iB = nl.iter();
            DoubleDBIDListIter iC = nl.iter();
            while (iB.valid()) {
                double sqdAB = iB.doubleValue();
                double simAB = kernelMatrix.getSimilarity(pA, iB);
                if (sqdAB > 0.0) {
                    iC.seek(iB.getOffset() + 1);
                    while (iC.valid()) {
                        double sqdAC = iC.doubleValue();
                        double simAC = kernelMatrix.getSimilarity(pA, iC);
                        if (sqdAC > 0.0) {
                            double simBC = kernelMatrix.getSimilarity(iB, iC);
                            double numerator = simBC - simAB - simAC + simAA;
                            double sqweight = 1.0 / (sqdAB * sqdAC);
                            double weight = FastMath.sqrt(sqweight);
                            double val = numerator * sqweight;
                            nnsum += val * weight;
                            nnsumsq += val * val * weight;
                            nnsumisqd += sqweight;
                        }
                        iC.advance();
                    }
                }
                iB.advance();
            }
            double r2 = sumisqd * sumisqd - 2.0 * nnsumisqd;
            double tmp = (2.0 * nnsum + r2) / (sumid * sumid);
            double lbabof = 2.0 * nnsumsq / (sumid * sumid) - tmp * tmp;
            if (lbabof > max) {
                max = lbabof;
            }
            abodvalues.putDouble(pA, lbabof);
            candidates.add(lbabof, pA);
            pA.advance();
        }
        minmaxabod.put(max);
        candidates.sort();
        int refinements = 0;
        DoubleMinHeap topscores = new DoubleMinHeap(this.l);
        MeanVariance s = new MeanVariance();
        DoubleDBIDListMIter pA2 = candidates.iter();
        while (pA2.valid() && (topscores.size() < this.k || !(pA2.doubleValue() > topscores.peek()))) {
            double abof = this.computeABOF(kernelMatrix, pA2, pB, pC, s);
            abodvalues.putDouble(pA2, abof);
            minmaxabod.put(abof);
            if (topscores.size() < this.k) {
                topscores.add(abof);
            } else if (topscores.peek() > abof) {
                topscores.replaceTopElement(abof);
            }
            ++refinements;
            pA2.advance();
        }
        if (LOG.isStatistics()) {
            LoggingConfiguration.setVerbose(Logging.Level.VERYVERBOSE);
            LOG.statistics(new LongStatistic("lb-abod.refinements", refinements));
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Angle-based Outlier Detection", "abod-outlier", abodvalues, ids);
        InvertedOutlierScoreMeta scoreMeta = new InvertedOutlierScoreMeta(minmaxabod.getMin(), minmaxabod.getMax(), 0.0, Double.POSITIVE_INFINITY);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends FastABOD.Parameterizer<V> {
        public static final OptionID L_ID = new OptionID("abod.l", "Number of top outliers to compute.");
        protected int l = 0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter lP = (IntParameter)new IntParameter(L_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(lP)) {
                this.l = (Integer)lP.getValue();
            }
        }

        @Override
        protected LBABOD<V> makeInstance() {
            return new LBABOD(this.kernelFunction, this.k, this.l);
        }
    }
}

