/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.em.EM;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Title(value="EM Outlier: Outlier Detection based on the generic EM clustering")
@Description(value="The outlier score assigned is based on the highest cluster probability obtained from EM clustering.")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.EMOutlier"})
public class EMOutlier<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(EMOutlier.class);
    private EM<V, ?> emClustering;

    public EMOutlier(EM<V, ?> emClustering) {
        this.emClustering = emClustering;
    }

    public OutlierResult run(Database database, Relation<V> relation) {
        this.emClustering.setSoft(true);
        Clustering<?> emresult = this.emClustering.run(database, relation);
        Relation soft = null;
        It<Relation> iter = emresult.getHierarchy().iterChildren(emresult).filter(Relation.class);
        while (iter.valid()) {
            if (iter.get().getDataTypeInformation() == EM.SOFT_TYPE) {
                soft = iter.get();
            }
            iter.advance();
        }
        if (soft == null) {
            throw new IllegalStateException("No soft assignment generated by EM?");
        }
        double globmax = 0.0;
        WritableDoubleDataStore emo_score = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double[] probs;
            double maxProb = Double.POSITIVE_INFINITY;
            for (double prob : probs = (double[])soft.get(iditer)) {
                maxProb = Math.min(1.0 - prob, maxProb);
            }
            emo_score.putDouble(iditer, maxProb);
            globmax = Math.max(maxProb, globmax);
            iditer.advance();
        }
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("EM outlier scores", "em-outlier", emo_score, relation.getDBIDs());
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore(0.0, globmax);
        OutlierResult result = new OutlierResult(meta, scoreres);
        result.addChildResult(emresult);
        return result;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected EM<V, ?> em;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            Class cls = ClassGenericsUtil.uglyCastIntoSubclass(EM.class);
            this.em = (EM)config.tryInstantiate(cls);
        }

        @Override
        protected EMOutlier<V> makeInstance() {
            return new EMOutlier<V>(this.em);
        }
    }
}

