/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.EvaluateSilhouette;
import de.lmu.ifi.dbs.elki.evaluation.clustering.internal.NoiseHandling;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

@Reference(authors="P. J. Rousseeuw", title="Silhouettes: A graphical aid to the interpretation and validation of cluster analysis", booktitle="Journal of Computational and Applied Mathematics, Volume 20", url="https://doi.org/10.1016/0377-0427(87)90125-7", bibkey="doi:10.1016/0377-04278790125-7")
public class SilhouetteOutlierDetection<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SilhouetteOutlierDetection.class);
    ClusteringAlgorithm<?> clusterer;
    private NoiseHandling noiseOption = NoiseHandling.TREAT_NOISE_AS_SINGLETONS;

    public SilhouetteOutlierDetection(DistanceFunction<? super O> distanceFunction, ClusteringAlgorithm<?> clusterer, NoiseHandling noiseOption) {
        super(distanceFunction);
        this.clusterer = clusterer;
        this.noiseOption = noiseOption;
    }

    @Override
    public OutlierResult run(Database database) {
        Relation relation = database.getRelation(this.getDistanceFunction().getInputTypeRestriction(), new Object[0]);
        DistanceQuery dq = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        Result c = this.clusterer.run(database);
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30);
        DoubleMinMax mm = new DoubleMinMax();
        List clusters = ((Clustering)c).getAllClusters();
        block8: for (Cluster cluster : clusters) {
            if (cluster.size() <= 1 || cluster.isNoise()) {
                switch (this.noiseOption) {
                    case IGNORE_NOISE: 
                    case TREAT_NOISE_AS_SINGLETONS: {
                        DBIDIter iter = cluster.getIDs().iter();
                        while (iter.valid()) {
                            scores.put((DBIDRef)iter, 0.0);
                            iter.advance();
                        }
                        mm.put(0.0);
                        continue block8;
                    }
                }
            }
            ArrayDBIDs ids = DBIDUtil.ensureArray(cluster.getIDs());
            double[] as = new double[ids.size()];
            DBIDArrayIter it1 = ids.iter();
            DBIDArrayIter it2 = ids.iter();
            it1.seek(0);
            while (it1.valid()) {
                double a = as[it1.getOffset()];
                it2.seek(it1.getOffset() + 1);
                while (it2.valid()) {
                    double dist = dq.distance((DBIDRef)it1, (DBIDRef)it2);
                    a += dist;
                    int n = it2.getOffset();
                    as[n] = as[n] + dist;
                    it2.advance();
                }
                a /= (double)(ids.size() - 1);
                double min = Double.POSITIVE_INFINITY;
                block12: for (Cluster ocluster : clusters) {
                    if (ocluster == cluster) continue;
                    if (ocluster.isNoise()) {
                        switch (this.noiseOption) {
                            case IGNORE_NOISE: {
                                continue block12;
                            }
                            case MERGE_NOISE: {
                                break;
                            }
                            case TREAT_NOISE_AS_SINGLETONS: {
                                DBIDIter it3 = ocluster.getIDs().iter();
                                while (it3.valid()) {
                                    double dist = dq.distance((DBIDRef)it1, (DBIDRef)it3);
                                    if (dist < min) {
                                        min = dist;
                                    }
                                    it3.advance();
                                }
                                continue block12;
                            }
                        }
                    }
                    DBIDs oids = ocluster.getIDs();
                    double b = 0.0;
                    DBIDIter it3 = oids.iter();
                    while (it3.valid()) {
                        b += dq.distance((DBIDRef)it1, (DBIDRef)it3);
                        it3.advance();
                    }
                    if (!((b /= (double)oids.size()) < min)) continue;
                    min = b;
                }
                double score = (min - a) / Math.max(min, a);
                scores.put((DBIDRef)it1, score);
                mm.put(score);
                it1.advance();
            }
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Silhouette Coefficients", "silhouette-outlier", scores, relation.getDBIDs());
        InvertedOutlierScoreMeta scoreMeta = new InvertedOutlierScoreMeta(mm.getMin(), mm.getMax(), -1.0, 1.0, 0.5);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        TypeInformation[] t;
        TypeInformation dt = this.getDistanceFunction().getInputTypeRestriction();
        for (TypeInformation i : t = this.clusterer.getInputTypeRestriction()) {
            if (!dt.isAssignableFromType(i)) continue;
            return t;
        }
        TypeInformation[] t2 = new TypeInformation[t.length + 1];
        t2[0] = dt;
        System.arraycopy(t, 0, t2, 1, t.length);
        return t2;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID CLUSTERING_ID = new OptionID("silhouette.clustering", "Clustering algorithm to use for the silhouette coefficients.");
        ClusteringAlgorithm<?> clusterer;
        private NoiseHandling noiseOption = NoiseHandling.TREAT_NOISE_AS_SINGLETONS;

        @Override
        protected void makeOptions(Parameterization config) {
            EnumParameter<NoiseHandling> noiseP;
            super.makeOptions(config);
            ObjectParameter clusterP = new ObjectParameter(CLUSTERING_ID, ClusteringAlgorithm.class);
            if (config.grab(clusterP)) {
                this.clusterer = (ClusteringAlgorithm)clusterP.instantiateClass(config);
            }
            if (config.grab(noiseP = new EnumParameter<NoiseHandling>(EvaluateSilhouette.Parameterizer.NOISE_ID, NoiseHandling.class, NoiseHandling.TREAT_NOISE_AS_SINGLETONS))) {
                this.noiseOption = (NoiseHandling)((Object)noiseP.getValue());
            }
        }

        @Override
        protected SilhouetteOutlierDetection<O> makeInstance() {
            return new SilhouetteOutlierDetection(this.distanceFunction, this.clusterer, this.noiseOption);
        }
    }
}

