/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Reference(authors="E. M. Knorr, R. T. Ng", title="Algorithms for Mining Distance-Based Outliers in Large Datasets", booktitle="Proc. Int. Conf. on Very Large Databases (VLDB'98)", url="http://www.vldb.org/conf/1998/p392.pdf", bibkey="DBLP:conf/vldb/KnorrN98")
public abstract class AbstractDBOutlier<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private double d;

    public AbstractDBOutlier(DistanceFunction<? super O> distanceFunction, double d) {
        super(distanceFunction);
        this.d = d;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DoubleDataStore dbodscore = this.computeOutlierScores(database, relation, this.d);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Density-Based Outlier Detection", "db-outlier", dbodscore, relation.getDBIDs());
        ProbabilisticOutlierScore scoreMeta = new ProbabilisticOutlierScore();
        return new OutlierResult(scoreMeta, scoreResult);
    }

    protected abstract DoubleDataStore computeOutlierScores(Database var1, Relation<O> var2, double var3);

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    public static abstract class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID D_ID = new OptionID("dbod.d", "size of the D-neighborhood");
        protected double d;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            this.configD(config, this.distanceFunction);
        }

        protected void configD(Parameterization config, DistanceFunction<?> distanceFunction) {
            DoubleParameter param = (DoubleParameter)new DoubleParameter(D_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(param)) {
                this.d = (Double)param.getValue();
            }
        }
    }
}

