/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.AbstractDBOutlier;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;

@Title(value="DBOD: Distance Based Outlier Detection")
@Description(value="If the D-neighborhood of an object contains only very few objects (less than (1-p) percent of the data) this object is flagged as an outlier")
@Reference(authors="E. M. Knorr, R. T. Ng", title="Algorithms for Mining Distance-Based Outliers in Large Datasets", booktitle="Proc. Int. Conf. on Very Large Databases (VLDB'98)", url="http://www.vldb.org/conf/1998/p392.pdf", bibkey="DBLP:conf/vldb/KnorrN98")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.DBOutlierDetection"})
public class DBOutlierDetection<O>
extends AbstractDBOutlier<O> {
    private static final Logging LOG = Logging.getLogger(DBOutlierDetection.class);
    private double p;

    public DBOutlierDetection(DistanceFunction<? super O> distanceFunction, double d, double p) {
        super(distanceFunction, d);
        this.p = p;
    }

    @Override
    protected DoubleDataStore computeOutlierScores(Database database, Relation<O> relation, double d) {
        FiniteProgress prog;
        DistanceQuery<O> distFunc = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnQuery = database.getKNNQuery(distFunc, "optimized");
        RangeQuery<O> rangeQuery = knnQuery == null ? database.getRangeQuery(distFunc, "optimized", d) : null;
        int m = (int)Math.floor((double)distFunc.getRelation().size() * (1.0 - this.p));
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(distFunc.getRelation().getDBIDs(), 4);
        FiniteProgress finiteProgress = prog = LOG.isVerbose() ? new FiniteProgress("DBOutlier detection", distFunc.getRelation().size(), LOG) : null;
        if (knnQuery != null) {
            if (LOG.isVeryVerbose()) {
                LOG.veryverbose("Using kNN query: " + knnQuery.toString());
            }
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                KNNList knns = knnQuery.getKNNForDBID(iditer, m);
                scores.putDouble(iditer, knns.getKNNDistance() > d ? 1.0 : 0.0);
                LOG.incrementProcessed(prog);
                iditer.advance();
            }
        } else if (rangeQuery != null) {
            if (LOG.isVeryVerbose()) {
                LOG.veryverbose("Using range query: " + rangeQuery.toString());
            }
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                DoubleDBIDList neighbors = rangeQuery.getRangeForDBID(iditer, d);
                scores.putDouble(iditer, neighbors.size() < m ? 1.0 : 0.0);
                LOG.incrementProcessed(prog);
                iditer.advance();
            }
        } else {
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                double currentDistance;
                int count = 0;
                DBIDIter iterator = relation.iterDBIDs();
                while (iterator.valid() && (!((currentDistance = distFunc.distance((DBIDRef)iditer, (DBIDRef)iterator)) <= d) || ++count < m)) {
                    iterator.advance();
                }
                scores.putDouble(iditer, count < m ? 1.0 : 0.0);
                LOG.incrementProcessed(prog);
                iditer.advance();
            }
        }
        LOG.ensureCompleted(prog);
        return scores;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDBOutlier.Parameterizer<O> {
        public static final OptionID P_ID = new OptionID("dbod.p", "minimum fraction of objects that must be outside the D-neighborhood of an outlier");
        protected double p = 0.0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter pP = (DoubleParameter)((DoubleParameter)new DoubleParameter(P_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE)).addConstraint((ParameterConstraint)CommonConstraints.LESS_THAN_ONE_DOUBLE);
            if (config.grab(pP)) {
                this.p = (Double)pP.getValue();
            }
        }

        @Override
        protected DBOutlierDetection<O> makeInstance() {
            return new DBOutlierDetection(this.distanceFunction, this.d, this.p);
        }
    }
}

