/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.AbstractDBOutlier;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Distance Based Outlier Score")
@Description(value="Generalization of the original DB-Outlier approach to a ranking method, by turning the fraction parameter into the output value.")
@Reference(prefix="Generalization of a method proposed in", authors="E. M. Knorr, R. T. Ng", title="Algorithms for Mining Distance-Based Outliers in Large Datasets", booktitle="Proc. Int. Conf. on Very Large Databases (VLDB'98)", url="http://www.vldb.org/conf/1998/p392.pdf", bibkey="DBLP:conf/vldb/KnorrN98")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.DBOutlierScore"})
public class DBOutlierScore<O>
extends AbstractDBOutlier<O> {
    private static final Logging LOG = Logging.getLogger(DBOutlierScore.class);

    public DBOutlierScore(DistanceFunction<? super O> distanceFunction, double d) {
        super(distanceFunction, d);
    }

    @Override
    protected DoubleDataStore computeOutlierScores(Database database, Relation<O> relation, double d) {
        DistanceQuery<O> distFunc = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        RangeQuery<O> rangeQuery = database.getRangeQuery(distFunc, new Object[0]);
        double size = distFunc.getRelation().size();
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(distFunc.getRelation().getDBIDs(), 4);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("DBOutlier scores", distFunc.getRelation().size(), LOG) : null;
        DBIDIter iditer = distFunc.getRelation().iterDBIDs();
        while (iditer.valid()) {
            double n = (double)rangeQuery.getRangeForDBID(iditer, d).size() / size;
            scores.putDouble(iditer, 1.0 - n);
            LOG.incrementProcessed(prog);
            iditer.advance();
        }
        LOG.ensureCompleted(prog);
        return scores;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDBOutlier.Parameterizer<O> {
        @Override
        protected DBOutlierScore<O> makeInstance() {
            return new DBOutlierScore(this.distanceFunction, this.d);
        }
    }
}

