/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.HilbertSpatialSorter;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparableMaxHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparatorMinHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ObjectHeap;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import net.jafama.FastMath;

@Title(value="Fast Outlier Detection in High Dimensional Spaces")
@Description(value="Algorithm to compute outliers using Hilbert space filling curves")
@Reference(authors="F. Angiulli, C. Pizzuti", title="Fast Outlier Detection in High Dimensional Spaces", booktitle="Proc. European Conf. Principles of Knowledge Discovery and Data Mining (PKDD'02)", url="https://doi.org/10.1007/3-540-45681-3_2", bibkey="DBLP:conf/pkdd/AngiulliP02")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.HilOut"})
public class HilOut<O extends NumberVector>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(HilOut.class);
    private int k;
    private int n;
    private int h;
    private double t;
    private Enum<ScoreType> tn;
    private DistanceQuery<O> distq;
    private int capital_n;
    private int n_star;
    private int capital_n_star;
    private int d;
    private double omega_star;

    protected HilOut(LPNormDistanceFunction distfunc, int k, int n, int h, Enum<ScoreType> tn) {
        super(distfunc);
        this.n = n;
        this.k = k - 1;
        this.h = h;
        this.tn = tn;
        this.t = distfunc.getP();
        this.n_star = 0;
        this.omega_star = 0.0;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        int i;
        this.distq = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        this.d = RelationUtil.dimensionality(relation);
        WritableDoubleDataStore hilout_weight = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        double diameter = 0.0;
        double[][] hbbs = RelationUtil.computeMinMax(relation);
        double[] min = hbbs[0];
        double[] max = hbbs[1];
        for (i = 0; i < this.d; ++i) {
            diameter = Math.max(diameter, max[i] - min[i]);
        }
        i = 0;
        while (i < this.d) {
            double diff = (diameter - (max[i] - min[i])) * 0.5;
            int n = i;
            min[n] = min[n] - diff;
            int n2 = i++;
            max[n2] = max[n2] + diff;
        }
        if (LOG.isVerbose()) {
            LOG.verbose("Rescaling dataset by " + 1.0 / diameter + " to fit the unit cube.");
        }
        this.capital_n_star = this.capital_n = relation.size();
        HilbertFeatures h = new HilbertFeatures(relation, min, diameter);
        FiniteProgress progressHilOut = LOG.isVerbose() ? new FiniteProgress("HilOut iterations", this.d + 1, LOG) : null;
        FiniteProgress progressTrueOut = LOG.isVerbose() ? new FiniteProgress("True outliers found", this.n, LOG) : null;
        for (int j = 0; j <= this.d && this.n_star < this.n; ++j) {
            HilFeature entry;
            h.out.clear();
            h.wlb.clear();
            h.initialize(0.5 * (double)j / (double)(this.d + 1));
            this.scan(h, (int)((double)(this.k * this.capital_n) / (double)this.capital_n_star));
            this.trueOutliers(h);
            if (progressTrueOut != null) {
                progressTrueOut.setProcessed(this.n_star, LOG);
            }
            h.top.clear();
            HashSetModifiableDBIDs top_keys = DBIDUtil.newHashSet(h.out.size());
            ObjectHeap.UnsortedIter iter = h.out.unsortedIter();
            while (iter.valid()) {
                entry = (HilFeature)iter.get();
                top_keys.add(entry.id);
                h.top.add(entry);
                iter.advance();
            }
            iter = h.wlb.unsortedIter();
            while (iter.valid()) {
                entry = (HilFeature)iter.get();
                if (!top_keys.contains(entry.id)) {
                    h.top.add(entry);
                }
                iter.advance();
            }
            LOG.incrementProcessed(progressHilOut);
        }
        if (this.n_star < this.n) {
            h.out.clear();
            h.wlb.clear();
            this.scan(h, this.capital_n);
        }
        if (progressHilOut != null) {
            progressHilOut.setProcessed(this.d, LOG);
            progressHilOut.ensureCompleted(LOG);
        }
        if (progressTrueOut != null) {
            progressTrueOut.setProcessed(this.n, LOG);
            progressTrueOut.ensureCompleted(LOG);
        }
        DoubleMinMax minmax = new DoubleMinMax();
        if (this.tn == ScoreType.TopN) {
            minmax.put(0.0);
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                hilout_weight.putDouble(iditer, 0.0);
                iditer.advance();
            }
            ObjectHeap.UnsortedIter iter = h.out.unsortedIter();
            while (iter.valid()) {
                HilFeature ent = (HilFeature)iter.get();
                minmax.put(ent.ubound);
                hilout_weight.putDouble(ent.id, ent.ubound);
                iter.advance();
            }
        } else {
            for (HilFeature ent : h.pf) {
                minmax.put(ent.ubound);
                hilout_weight.putDouble(ent.id, ent.ubound);
            }
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("HilOut weight", "hilout-weight", hilout_weight, relation.getDBIDs());
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        OutlierResult result = new OutlierResult(scoreMeta, scoreResult);
        return result;
    }

    private void scan(HilbertFeatures hf, int k0) {
        int mink0 = Math.min(2 * k0, this.capital_n - 1);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Scanning with k0=" + k0 + " (" + mink0 + ") N*=" + this.capital_n_star);
        }
        for (int i = 0; i < hf.pf.length; ++i) {
            if (hf.pf[i].ubound < this.omega_star) continue;
            if (hf.pf[i].lbound < hf.pf[i].ubound) {
                double omega = hf.fastUpperBound(i);
                if (omega < this.omega_star) {
                    hf.pf[i].ubound = omega;
                } else {
                    int maxcount = hf.top.contains(hf.pf[i]) ? this.capital_n - 1 : mink0;
                    this.innerScan(hf, i, maxcount);
                }
            }
            if (hf.pf[i].ubound > 0.0) {
                hf.updateOUT(i);
            }
            if (hf.pf[i].lbound > 0.0) {
                hf.updateWLB(i);
            }
            if (hf.wlb.size() < this.n) continue;
            this.omega_star = Math.max(this.omega_star, ((HilFeature)((HilbertFeatures)hf).wlb.peek()).lbound);
        }
    }

    private void innerScan(HilbertFeatures hf, int i, int maxcount) {
        NumberVector p = (NumberVector)hf.relation.get(hf.pf[i].id);
        int a = i;
        int b = i;
        int level = this.h;
        int levela = this.h;
        int levelb = this.h;
        for (int count = 0; count < maxcount; ++count) {
            double delta;
            int mlevel;
            int c;
            if (a == 0) {
                levelb = Math.min(levelb, hf.pf[b].level);
                c = ++b;
            } else if (b >= this.capital_n - 1) {
                levela = Math.min(levela, hf.pf[--a].level);
                c = a;
            } else if (hf.pf[a - 1].level >= hf.pf[b].level) {
                levela = Math.min(levela, hf.pf[--a].level);
                c = a;
            } else {
                levelb = Math.min(levelb, hf.pf[b].level);
                c = ++b;
            }
            if (hf.pf[i].nn_keys.contains(hf.pf[c].id)) continue;
            hf.pf[i].insert(hf.pf[c].id, this.distq.distance((DBID)((Object)p), hf.pf[c].id), this.k);
            if (hf.pf[i].nn.size() == this.k && (hf.pf[i].sum_nn < this.omega_star || (mlevel = Math.max(levela, levelb)) < level && (delta = hf.minDistLevel(hf.pf[i].id, level = mlevel)) >= hf.pf[i].nn.peek().doubleValue())) break;
        }
        double br = hf.boxRadius(i, a - 1, b + 1);
        double newlb = 0.0;
        double newub = 0.0;
        ObjectHeap.UnsortedIter<DoubleDBIDPair> iter = hf.pf[i].nn.unsortedIter();
        while (iter.valid()) {
            DoubleDBIDPair entry = iter.get();
            newub += entry.doubleValue();
            if (entry.doubleValue() <= br) {
                newlb += entry.doubleValue();
            }
            iter.advance();
        }
        if (newlb > hf.pf[i].lbound) {
            hf.pf[i].lbound = newlb;
        }
        if (newub < hf.pf[i].ubound) {
            hf.pf[i].ubound = newub;
        }
    }

    private void trueOutliers(HilbertFeatures h) {
        this.n_star = 0;
        ObjectHeap.UnsortedIter iter = h.out.unsortedIter();
        while (iter.valid()) {
            HilFeature entry = (HilFeature)iter.get();
            if (entry.ubound >= this.omega_star && entry.ubound - entry.lbound < 1.0E-10) {
                ++this.n_star;
            }
            iter.advance();
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(new LPNormDistanceFunction(this.t).getInputTypeRestriction());
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID K_ID = new OptionID("HilOut.k", "Compute up to k next neighbors");
        public static final OptionID N_ID = new OptionID("HilOut.n", "Compute n outliers");
        public static final OptionID H_ID = new OptionID("HilOut.h", "Max. Hilbert-Level");
        public static final OptionID T_ID = new OptionID("HilOut.t", "t of Lt Metric");
        public static final OptionID TN_ID = new OptionID("HilOut.tn", "output of Top n or all elements");
        protected int k = 5;
        protected int n = 10;
        protected int h = 32;
        protected LPNormDistanceFunction distfunc;
        protected Enum<ScoreType> tn;

        @Override
        protected void makeOptions(Parameterization config) {
            EnumParameter<ScoreType> tnP;
            ObjectParameter distP;
            IntParameter hP;
            IntParameter nP;
            super.makeOptions(config);
            IntParameter kP = new IntParameter(K_ID, 5);
            if (config.grab(kP)) {
                this.k = (Integer)kP.getValue();
            }
            if (config.grab(nP = new IntParameter(N_ID, 10))) {
                this.n = (Integer)nP.getValue();
            }
            if (config.grab(hP = new IntParameter(H_ID, 32))) {
                this.h = (Integer)hP.getValue();
            }
            if (config.grab(distP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)LPNormDistanceFunction.class, EuclideanDistanceFunction.class))) {
                this.distfunc = (LPNormDistanceFunction)distP.instantiateClass(config);
            }
            if (config.grab(tnP = new EnumParameter<ScoreType>(TN_ID, ScoreType.class, ScoreType.TopN))) {
                this.tn = (Enum)tnP.getValue();
            }
        }

        @Override
        protected HilOut<O> makeInstance() {
            return new HilOut(this.distfunc, this.k, this.n, this.h, this.tn);
        }
    }

    static final class HilFeature
    implements Comparable<HilFeature> {
        public DBID id;
        public long[] hilbert = null;
        public int level = 0;
        public double ubound = Double.POSITIVE_INFINITY;
        public double lbound = 0.0;
        public ObjectHeap<DoubleDBIDPair> nn;
        public HashSetModifiableDBIDs nn_keys = DBIDUtil.newHashSet();
        public double sum_nn = 0.0;

        public HilFeature(DBID id, ObjectHeap<DoubleDBIDPair> nn) {
            this.id = id;
            this.nn = nn;
        }

        @Override
        public int compareTo(HilFeature o) {
            return BitsUtil.compare(this.hilbert, o.hilbert);
        }

        protected void insert(DBID id, double dt, int k) {
            if (this.nn.size() < k) {
                DoubleDBIDPair entry = DBIDUtil.newPair(dt, (DBIDRef)id);
                this.nn.add(entry);
                this.nn_keys.add(id);
                this.sum_nn += dt;
            } else {
                DoubleDBIDPair head = this.nn.peek();
                if (dt < head.doubleValue()) {
                    head = this.nn.poll();
                    this.sum_nn -= head.doubleValue();
                    this.nn_keys.remove(head);
                    DoubleDBIDPair entry = DBIDUtil.newPair(dt, (DBIDRef)id);
                    this.nn.add(entry);
                    this.nn_keys.add(id);
                    this.sum_nn += dt;
                }
            }
        }
    }

    class HilbertFeatures {
        Relation<O> relation;
        HilFeature[] pf;
        double[] min;
        double diameter;
        double shift;
        private Set<HilFeature> top;
        private ObjectHeap<HilFeature> out;
        private ObjectHeap<HilFeature> wlb;

        public HilbertFeatures(Relation<O> relation, double[] min, double diameter) {
            this.relation = relation;
            this.min = min;
            this.diameter = diameter;
            this.pf = new HilFeature[relation.size()];
            int pos = 0;
            DBIDIter iditer = relation.iterDBIDs();
            while (iditer.valid()) {
                this.pf[pos++] = new HilFeature(DBIDUtil.deref(iditer), new ComparableMaxHeap<DoubleDBIDPair>(HilOut.this.k));
                iditer.advance();
            }
            this.out = new ComparatorMinHeap<HilFeature>(HilOut.this.n, new Comparator<HilFeature>(){

                @Override
                public int compare(HilFeature o1, HilFeature o2) {
                    return Double.compare(o1.ubound, o2.ubound);
                }
            });
            this.wlb = new ComparatorMinHeap<HilFeature>(HilOut.this.n, new Comparator<HilFeature>(){

                @Override
                public int compare(HilFeature o1, HilFeature o2) {
                    return Double.compare(o1.lbound, o2.lbound);
                }
            });
            this.top = new HashSet<HilFeature>(2 * HilOut.this.n);
        }

        private void initialize(double shift) {
            int i;
            Object[] coord;
            int i2;
            this.shift = shift;
            if (HilOut.this.h >= 32) {
                long scale = Long.MAX_VALUE;
                for (int i3 = 0; i3 < this.pf.length; ++i3) {
                    NumberVector obj = (NumberVector)this.relation.get(this.pf[i3].id);
                    long[] coord2 = new long[HilOut.this.d];
                    for (int dim = 0; dim < HilOut.this.d; ++dim) {
                        coord2[dim] = (long)(this.getDimForObject(obj, dim) * 0.5 * 9.223372036854776E18);
                    }
                    this.pf[i3].hilbert = HilbertSpatialSorter.coordinatesToHilbert(coord2, HilOut.this.h, 1);
                }
            } else if (HilOut.this.h >= 16) {
                int scale = Integer.MAX_VALUE;
                for (i2 = 0; i2 < this.pf.length; ++i2) {
                    NumberVector obj = (NumberVector)this.relation.get(this.pf[i2].id);
                    coord = new int[HilOut.this.d];
                    for (int dim = 0; dim < HilOut.this.d; ++dim) {
                        coord[dim] = (int)(this.getDimForObject(obj, dim) * 0.5 * 2.147483647E9);
                    }
                    this.pf[i2].hilbert = HilbertSpatialSorter.coordinatesToHilbert(coord, HilOut.this.h, 1);
                }
            } else if (HilOut.this.h >= 8) {
                int scale = 65535;
                for (i2 = 0; i2 < this.pf.length; ++i2) {
                    NumberVector obj = (NumberVector)this.relation.get(this.pf[i2].id);
                    coord = new short[HilOut.this.d];
                    for (int dim = 0; dim < HilOut.this.d; ++dim) {
                        coord[dim] = (short)(this.getDimForObject(obj, dim) * 0.5 * 65535.0);
                    }
                    this.pf[i2].hilbert = HilbertSpatialSorter.coordinatesToHilbert((short[])coord, HilOut.this.h, 16);
                }
            } else {
                int scale = 0xFFFFFF;
                for (i2 = 0; i2 < this.pf.length; ++i2) {
                    NumberVector obj = (NumberVector)this.relation.get(this.pf[i2].id);
                    coord = new byte[HilOut.this.d];
                    for (int dim = 0; dim < HilOut.this.d; ++dim) {
                        coord[dim] = (byte)(this.getDimForObject(obj, dim) * 0.5 * 1.6777215E7);
                    }
                    this.pf[i2].hilbert = HilbertSpatialSorter.coordinatesToHilbert((byte[])coord, HilOut.this.h, 24);
                }
            }
            Arrays.sort(this.pf);
            for (i = 0; i < this.pf.length - 1; ++i) {
                this.pf[i].level = this.minRegLevel(i, i + 1);
            }
            HilOut.this.capital_n_star = 0;
            for (i = 0; i < this.pf.length; ++i) {
                if (!(this.pf[i].ubound >= HilOut.this.omega_star)) continue;
                HilOut.this.capital_n_star++;
            }
        }

        private void updateOUT(int i) {
            if (this.out.size() < HilOut.this.n) {
                this.out.add(this.pf[i]);
            } else {
                HilFeature head = this.out.peek();
                if (this.pf[i].ubound > head.ubound) {
                    this.out.replaceTopElement(this.pf[i]);
                }
            }
        }

        private void updateWLB(int i) {
            if (this.wlb.size() < HilOut.this.n) {
                this.wlb.add(this.pf[i]);
            } else {
                HilFeature head = this.wlb.peek();
                if (this.pf[i].lbound > head.lbound) {
                    this.wlb.replaceTopElement(this.pf[i]);
                }
            }
        }

        private double fastUpperBound(int i) {
            int pre = i;
            int post = i;
            while (post - pre < HilOut.this.k) {
                int post_level;
                int pre_level = pre - 1 >= 0 ? this.pf[pre - 1].level : -2;
                int n = post_level = post < HilOut.this.capital_n - 1 ? this.pf[post].level : -2;
                if (post_level >= pre_level) {
                    ++post;
                    continue;
                }
                --pre;
            }
            return (double)HilOut.this.k * this.maxDistLevel(this.pf[i].id, this.minRegLevel(pre, post));
        }

        private double minDistLevel(DBID id, int level) {
            NumberVector obj = (NumberVector)this.relation.get(id);
            double r = 1.0 / (double)(1 << level - 1);
            double dist = Double.POSITIVE_INFINITY;
            for (int dim = 0; dim < HilOut.this.d; ++dim) {
                double p_m_r = this.getDimForObject(obj, dim) % r;
                dist = Math.min(dist, Math.min(p_m_r, r - p_m_r));
            }
            return dist * this.diameter;
        }

        private double maxDistLevel(DBID id, int level) {
            double dist;
            NumberVector obj = (NumberVector)this.relation.get(id);
            double r = 1.0 / (double)(1 << level - 1);
            if (HilOut.this.t == 1.0) {
                dist = 0.0;
                for (int dim = 0; dim < HilOut.this.d; ++dim) {
                    double p_m_r = this.getDimForObject(obj, dim) % r;
                    dist += Math.max(p_m_r, r - p_m_r);
                }
            } else if (HilOut.this.t == 2.0) {
                dist = 0.0;
                for (int dim = 0; dim < HilOut.this.d; ++dim) {
                    double p_m_r = this.getDimForObject(obj, dim) % r;
                    double a = Math.max(p_m_r, r - p_m_r);
                    dist += a * a;
                }
                dist = FastMath.sqrt(dist);
            } else if (!Double.isInfinite(HilOut.this.t)) {
                dist = 0.0;
                for (int dim = 0; dim < HilOut.this.d; ++dim) {
                    double p_m_r = this.getDimForObject(obj, dim) % r;
                    dist += FastMath.pow(Math.max(p_m_r, r - p_m_r), HilOut.this.t);
                }
                dist = FastMath.pow(dist, 1.0 / HilOut.this.t);
            } else {
                dist = Double.NEGATIVE_INFINITY;
                for (int dim = 0; dim < HilOut.this.d; ++dim) {
                    double p_m_r = this.getDimForObject(obj, dim) % r;
                    dist = Math.max(dist, Math.max(p_m_r, r - p_m_r));
                }
            }
            return dist * this.diameter;
        }

        private int numberSharedLevels(long[] a, long[] b) {
            int i = 0;
            int j = a.length - 1;
            while (i < a.length) {
                long diff = a[j] ^ b[j];
                if (diff != 0L) {
                    int expected = a.length * 64 - HilOut.this.d * HilOut.this.h;
                    return (BitsUtil.numberOfLeadingZeros(diff) + i * 64 - expected) / HilOut.this.d;
                }
                ++i;
                --j;
            }
            return HilOut.this.h - 1;
        }

        private int minRegLevel(int a, int b) {
            return this.numberSharedLevels(this.pf[a].hilbert, this.pf[b].hilbert);
        }

        private int maxRegLevel(int ref, int q) {
            return this.numberSharedLevels(this.pf[ref].hilbert, this.pf[q].hilbert) + 1;
        }

        private double boxRadius(int i, int a, int b) {
            int level;
            if (a < 0) {
                if (b >= this.pf.length) {
                    return Double.POSITIVE_INFINITY;
                }
                level = this.maxRegLevel(i, b);
            } else {
                level = b >= this.pf.length ? this.maxRegLevel(i, a) : Math.max(this.maxRegLevel(i, a), this.maxRegLevel(i, b));
            }
            return this.minDistLevel(this.pf[i].id, level);
        }

        private double getDimForObject(NumberVector obj, int dim) {
            return (obj.doubleValue(dim) - this.min[dim]) / this.diameter + this.shift;
        }
    }

    public static enum ScoreType {
        All,
        TopN;

    }
}

