/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="KNNDD: k-Nearest Neighbor Data Description")
@Reference(authors="D. de Ridder, D. M. J. Tax, R. P. W. Duin", title="An experimental comparison of one-class classification methods", booktitle="Proc. 4th Ann. Conf. Advanced School for Computing and Imaging (ASCI'98)", url="http://prlab.tudelft.nl/sites/default/files/asci_98.pdf", bibkey="conf/asci/deRidderTD98")
public class KNNDD<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(KNNDD.class);
    private int k;

    public KNNDD(DistanceFunction<? super O> distanceFunction, int k) {
        super(distanceFunction);
        this.k = k + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        return this.run(relation);
    }

    public OutlierResult run(Relation<O> relation) {
        DistanceQuery<O> distanceQuery = relation.getDistanceQuery(this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnQuery = relation.getKNNQuery(distanceQuery, this.k);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("kNN distance for objects", relation.size(), LOG) : null;
        WritableDoubleDataStore knnDist = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        WritableDBIDDataStore neighbor = DataStoreUtil.makeDBIDStorage(relation.getDBIDs(), 3);
        DBIDVar var = DBIDUtil.newVar();
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            KNNList knn = knnQuery.getKNNForDBID(it, this.k);
            knnDist.putDouble(it, knn.getKNNDistance());
            neighbor.put((DBIDRef)it, knn.assignVar(knn.size() - 1, var));
            LOG.incrementProcessed(prog);
            it.advance();
        }
        LOG.ensureCompleted(prog);
        prog = LOG.isVerbose() ? new FiniteProgress("kNN distance descriptor", relation.size(), LOG) : null;
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30);
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter it2 = relation.iterDBIDs();
        while (it2.valid()) {
            double d = knnDist.doubleValue(it2);
            double nd = knnDist.doubleValue(neighbor.assignVar(it2, var));
            double knndd = nd > 0.0 ? d / nd : (d > 0.0 ? Double.POSITIVE_INFINITY : 1.0);
            scores.put((DBIDRef)it2, knndd);
            minmax.put(knndd);
            LOG.incrementProcessed(prog);
            it2.advance();
        }
        LOG.ensureCompleted(prog);
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("kNN Data Descriptor", "knndd-outlier", scores, relation.getDBIDs());
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(meta, scoreres);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("knndd.k", "The k nearest neighbor, excluding the query point (i.e. query point is the 0-nearest-neighbor)");
        protected int k = 0;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID, 1).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = (Integer)kP.getValue();
            }
        }

        @Override
        protected KNNDD<O> makeInstance() {
            return new KNNDD(this.distanceFunction, this.k);
        }
    }
}

