/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.SOS;
import de.lmu.ifi.dbs.elki.algorithm.outlier.intrinsic.ISOS;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.References;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import net.jafama.FastMath;

@Title(value="KNNSOS: k-Nearest-Neighbor Stochastic Outlier Selection")
@References(value={@Reference(authors="Erich Schubert, Michael Gertz", title="Intrinsic t-Stochastic Neighbor Embedding for Visualization and Outlier Detection: A Remedy Against the Curse of Dimensionality?", booktitle="Proc. Int. Conf. Similarity Search and Applications, SISAP'2017", url="https://doi.org/10.1007/978-3-319-68474-1_13", bibkey="DBLP:conf/sisap/SchubertG17"), @Reference(authors="J. Janssens, F. Husz\u00e1r, E. Postma, J. van den Herik", title="Stochastic Outlier Selection", booktitle="TiCC TR 2012\u2013001", url="https://www.tilburguniversity.edu/upload/b7bac5b2-9b00-402a-9261-7849aa019fbb_sostr.pdf", bibkey="tr/tilburg/JanssensHPv12")})
public class KNNSOS<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(KNNSOS.class);
    protected int k;
    protected double phi = 0.01;

    public KNNSOS(DistanceFunction<? super O> distance, int k) {
        super(distance);
        this.k = k;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    public OutlierResult run(Relation<O> relation) {
        int k1 = this.k + 1;
        double perplexity = (double)this.k / 3.0;
        KNNQuery<O> knnq = relation.getKNNQuery(this.getDistanceFunction(), k1);
        double logPerp = perplexity > 1.0 ? FastMath.log(perplexity) : 0.1;
        double[] p = new double[this.k + 10];
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("KNNSOS scores", relation.size(), LOG) : null;
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30, 1.0);
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            KNNList knns = knnq.getKNNForDBID(it, k1);
            if (p.length < knns.size() + 1) {
                p = new double[knns.size() + 10];
            }
            DoubleDBIDListIter ki = knns.iter();
            SOS.computePi(it, ki, p, perplexity, logPerp);
            double s = SOS.sumOfProbabilities(it, ki, p);
            if (s > 0.0) {
                ISOS.nominateNeighbors(it, ki, p, 1.0 / s, scores);
            }
            LOG.incrementProcessed(prog);
            it.advance();
        }
        LOG.ensureCompleted(prog);
        DoubleMinMax minmax = ISOS.transformScores(scores, relation.getDBIDs(), logPerp, this.phi);
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("kNN Stoachastic Outlier Selection", "knnsos-outlier", scores, relation.getDBIDs());
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore(minmax.getMin(), minmax.getMax(), 0.0);
        return new OutlierResult(meta, scoreres);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID KNN_ID = new OptionID("sos.k", "Number of neighbors to use. Should be about 3x the desired perplexity.");
        int k = 15;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(KNN_ID, 15).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
        }

        @Override
        protected KNNSOS<O> makeInstance() {
            return new KNNSOS(this.distanceFunction, this.k);
        }
    }
}

