/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="KNNWeight outlier detection")
@Description(value="Outlier detection based on the sum of distances of an object to its k nearest neighbors.")
@Reference(authors="F. Angiulli, C. Pizzuti", title="Fast Outlier Detection in High Dimensional Spaces", booktitle="Proc. European Conf. Principles of Knowledge Discovery and Data Mining (PKDD'02)", url="https://doi.org/10.1007/3-540-45681-3_2", bibkey="DBLP:conf/pkdd/AngiulliP02")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.KNNWeightOutlier", "knnw"})
public class KNNWeightOutlier<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(KNNWeightOutlier.class);
    private int k;

    public KNNWeightOutlier(DistanceFunction<? super O> distanceFunction, int k) {
        super(distanceFunction);
        this.k = k;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnQuery = database.getKNNQuery(distanceQuery, this.k + 1);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Compute kNN weights", relation.size(), LOG) : null;
        DoubleMinMax minmax = new DoubleMinMax();
        WritableDoubleDataStore knnw_score = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList knn = knnQuery.getKNNForDBID(iditer, this.k + 1);
            double skn = 0.0;
            int i = 0;
            DoubleDBIDListIter neighbor = knn.iter();
            while (i < this.k && neighbor.valid()) {
                if (!DBIDUtil.equal(iditer, neighbor)) {
                    skn += neighbor.doubleValue();
                    ++i;
                }
                neighbor.advance();
            }
            if (i < this.k) {
                skn = Double.POSITIVE_INFINITY;
            }
            knnw_score.putDouble(iditer, skn);
            minmax.put(skn);
            LOG.incrementProcessed(prog);
            iditer.advance();
        }
        LOG.ensureCompleted(prog);
        MaterializedDoubleRelation res = new MaterializedDoubleRelation("kNN weight Outlier Score", "knnw-outlier", knnw_score, relation.getDBIDs());
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(meta, res);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("knnwod.k", "The k nearest neighbor, excluding the query point (i.e. query point is the 0-nearest-neighbor)");
        protected int k;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = (Integer)kP.getValue();
            }
        }

        @Override
        protected KNNWeightOutlier<O> makeInstance() {
            return new KNNWeightOutlier(this.distanceFunction, this.k);
        }
    }
}

