/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractNumberVectorDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.ReferencePointsResult;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.GridBasedReferencePoints;
import de.lmu.ifi.dbs.elki.utilities.referencepoints.ReferencePointsHeuristic;
import java.util.Collection;

@Title(value="An Efficient Reference-based Approach to Outlier Detection in Large Datasets")
@Description(value="Computes kNN distances approximately, using reference points with various reference point strategies.")
@Reference(authors="Y. Pei, O. R. Zaiane, Y. Gao", title="An Efficient Reference-based Approach to Outlier Detection in Large Datasets", booktitle="Proc. 6th IEEE Int. Conf. on Data Mining (ICDM '06)", url="https://doi.org/10.1109/ICDM.2006.17", bibkey="DBLP:conf/icdm/PeiZG06")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.ReferenceBasedOutlierDetection"})
public class ReferenceBasedOutlierDetection
extends AbstractNumberVectorDistanceBasedAlgorithm<NumberVector, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ReferenceBasedOutlierDetection.class);
    private int k;
    private ReferencePointsHeuristic refp;

    public ReferenceBasedOutlierDetection(int k, NumberVectorDistanceFunction<? super NumberVector> distanceFunction, ReferencePointsHeuristic refp) {
        super(distanceFunction);
        this.k = k;
        this.refp = refp;
    }

    public OutlierResult run(Database database, Relation<? extends NumberVector> relation) {
        PrimitiveDistanceQuery distq = (PrimitiveDistanceQuery)database.getDistanceQuery(relation, this.distanceFunction, new Object[0]);
        Collection<? extends NumberVector> refPoints = this.refp.getReferencePoints(relation);
        if (refPoints.isEmpty()) {
            throw new AbortException("Cannot compute ROS without reference points!");
        }
        DBIDs ids = relation.getDBIDs();
        if (this.k >= ids.size()) {
            throw new AbortException("k must not be chosen larger than the database size!");
        }
        WritableDoubleDataStore rbod_score = DataStoreUtil.makeDoubleStorage(ids, 6, Double.NaN);
        for (NumberVector numberVector : refPoints) {
            DoubleDBIDList referenceDists = this.computeDistanceVector(numberVector, relation, distq);
            this.updateDensities(rbod_score, referenceDists);
        }
        DoubleMinMax mm = new DoubleMinMax();
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            mm.put(rbod_score.doubleValue(dBIDIter));
            dBIDIter.advance();
        }
        double d = mm.getMax() > 0.0 ? 1.0 / mm.getMax() : 1.0;
        mm.reset();
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            double score = 1.0 - rbod_score.doubleValue(iditer2) * d;
            mm.put(score);
            rbod_score.putDouble(iditer2, score);
            iditer2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Reference-points Outlier Scores", "reference-outlier", rbod_score, relation.getDBIDs());
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(mm.getMin(), mm.getMax(), 0.0, 1.0, 0.0);
        OutlierResult result = new OutlierResult(scoreMeta, scoreResult);
        result.addChildResult(new ReferencePointsResult<NumberVector>("Reference points", "reference-points", refPoints));
        return result;
    }

    protected DoubleDBIDList computeDistanceVector(NumberVector refPoint, Relation<? extends NumberVector> database, PrimitiveDistanceQuery<? super NumberVector> distFunc) {
        ModifiableDoubleDBIDList referenceDists = DBIDUtil.newDistanceDBIDList(database.size());
        DBIDIter iditer = database.iterDBIDs();
        while (iditer.valid()) {
            referenceDists.add(distFunc.distance((NumberVector)((Object)iditer), refPoint), iditer);
            iditer.advance();
        }
        referenceDists.sort();
        return referenceDists;
    }

    protected void updateDensities(WritableDoubleDataStore rbod_score, DoubleDBIDList referenceDists) {
        DoubleDBIDListIter it = referenceDists.iter();
        for (int l = 0; l < referenceDists.size(); ++l) {
            double density = this.computeDensity(referenceDists, it, l);
            it.seek(l);
            if (density > rbod_score.doubleValue(it)) continue;
            rbod_score.putDouble(it, density);
        }
    }

    protected double computeDensity(DoubleDBIDList referenceDists, DoubleDBIDListIter iter, int index) {
        int size = referenceDists.size();
        double xDist = iter.seek(index).doubleValue();
        int lef = index;
        int rig = index;
        double sum = 0.0;
        double lef_d = --lef >= 0 ? xDist - iter.seek(lef).doubleValue() : Double.POSITIVE_INFINITY;
        double rig_d = ++rig < size ? iter.seek(rig).doubleValue() - xDist : Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.k; ++i) {
            if (lef >= 0 && rig < size) {
                if (lef_d < rig_d) {
                    sum += lef_d;
                    lef_d = --lef >= 0 ? xDist - iter.seek(lef).doubleValue() : Double.POSITIVE_INFINITY;
                    continue;
                }
                sum += rig_d;
                rig_d = ++rig < size ? iter.seek(rig).doubleValue() - xDist : Double.POSITIVE_INFINITY;
                continue;
            }
            if (lef >= 0) {
                sum += lef_d;
                lef_d = --lef >= 0 ? xDist - iter.seek(lef).doubleValue() : Double.POSITIVE_INFINITY;
                continue;
            }
            if (rig < size) {
                sum += rig_d;
                rig_d = ++rig < size ? iter.seek(rig).doubleValue() - xDist : Double.POSITIVE_INFINITY;
                continue;
            }
            throw new IndexOutOfBoundsException("Less than k objects?");
        }
        return (double)this.k / sum;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.distanceFunction.getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractNumberVectorDistanceBasedAlgorithm.Parameterizer<NumberVector> {
        public static final OptionID REFP_ID = new OptionID("refod.refp", "The heuristic for finding reference points.");
        public static final OptionID K_ID = new OptionID("refod.k", "The number of nearest neighbors");
        private int k;
        private ReferencePointsHeuristic refp;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter refpP;
            super.makeOptions(config);
            IntParameter pK = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(pK)) {
                this.k = (Integer)pK.getValue();
            }
            if (config.grab(refpP = new ObjectParameter(REFP_ID, (Class<?>)ReferencePointsHeuristic.class, GridBasedReferencePoints.class))) {
                this.refp = (ReferencePointsHeuristic)refpP.instantiateClass(config);
            }
        }

        @Override
        protected ReferenceBasedOutlierDetection makeInstance() {
            return new ReferenceBasedOutlierDetection(this.k, this.distanceFunction, this.refp);
        }
    }
}

