/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import net.jafama.FastMath;

@Title(value="SOS: Stochastic Outlier Selection")
@Reference(authors="J. Janssens, F. Husz\u00e1r, E. Postma, J. van den Herik", title="Stochastic Outlier Selection", booktitle="TiCC TR 2012\u2013001", url="https://www.tilburguniversity.edu/upload/b7bac5b2-9b00-402a-9261-7849aa019fbb_sostr.pdf", bibkey="tr/tilburg/JanssensHPv12")
public class SOS<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SOS.class);
    protected static final double PERPLEXITY_ERROR = 1.0E-5;
    protected static final int PERPLEXITY_MAXITER = 50;
    protected double perplexity;

    public SOS(DistanceFunction<? super O> distance, double h) {
        super(distance);
        this.perplexity = h;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    public OutlierResult run(Relation<O> relation) {
        DistanceQuery<O> dq = relation.getDistanceQuery(this.getDistanceFunction(), new Object[0]);
        double logPerp = FastMath.log(this.perplexity);
        ModifiableDoubleDBIDList dlist = DBIDUtil.newDistanceDBIDList(relation.size() - 1);
        DoubleDBIDListMIter di = dlist.iter();
        double[] p = new double[relation.size() - 1];
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("SOS scores", relation.size(), LOG) : null;
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30, 1.0);
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            dlist.clear();
            DBIDIter i2 = relation.iterDBIDs();
            while (i2.valid()) {
                if (!DBIDUtil.equal(it, i2)) {
                    dlist.add(dq.distance((DBIDRef)it, (DBIDRef)i2), i2);
                }
                i2.advance();
            }
            dlist.sort();
            SOS.computePi(it, di, p, this.perplexity, logPerp);
            double s = SOS.sumOfProbabilities(it, di, p);
            if (s > 0.0) {
                SOS.nominateNeighbors(it, di, p, 1.0 / s, scores);
            }
            LOG.incrementProcessed(prog);
            it.advance();
        }
        LOG.ensureCompleted(prog);
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter it2 = relation.iterDBIDs();
        while (it2.valid()) {
            minmax.put(scores.doubleValue(it2));
            it2.advance();
        }
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Stoachastic Outlier Selection", "sos-outlier", scores, relation.getDBIDs());
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore(minmax.getMin(), minmax.getMax(), 0.0);
        return new OutlierResult(meta, scoreres);
    }

    public static double sumOfProbabilities(DBIDIter ignore, DBIDArrayIter di, double[] p) {
        double s = 0.0;
        di.seek(0);
        while (di.valid()) {
            if (!DBIDUtil.equal(ignore, di)) {
                double v = p[di.getOffset()];
                if (!(v > 0.0)) break;
                s += v;
            }
            di.advance();
        }
        return s;
    }

    public static void nominateNeighbors(DBIDIter ignore, DBIDArrayIter di, double[] p, double norm, WritableDoubleDataStore scores) {
        di.seek(0);
        while (di.valid()) {
            if (!DBIDUtil.equal(ignore, di)) {
                double v = p[di.getOffset()] * norm;
                if (!(v > 0.0)) break;
                scores.putDouble(di, scores.doubleValue(di) * (1.0 - v));
            }
            di.advance();
        }
    }

    public static double computePi(DBIDRef ignore, DoubleDBIDListIter it, double[] p, double perplexity, double logPerp) {
        double beta = SOS.estimateInitialBeta(ignore, it, perplexity);
        double diff = SOS.computeH(ignore, it, p, -beta) - logPerp;
        double betaMin = 0.0;
        double betaMax = Double.POSITIVE_INFINITY;
        for (int tries = 0; tries < 50 && Math.abs(diff) > 1.0E-5; ++tries) {
            if (diff > 0.0) {
                betaMin = beta;
                beta += betaMax == Double.POSITIVE_INFINITY ? beta : (betaMax - beta) * 0.5;
            } else {
                betaMax = beta;
                beta -= (beta - betaMin) * 0.5;
            }
            diff = SOS.computeH(ignore, it, p, -beta) - logPerp;
        }
        return beta;
    }

    @Reference(authors="Erich Schubert, Michael Gertz", title="Intrinsic t-Stochastic Neighbor Embedding for Visualization and Outlier Detection: A Remedy Against the Curse of Dimensionality?", booktitle="Proc. Int. Conf. Similarity Search and Applications, SISAP'2017", url="https://doi.org/10.1007/978-3-319-68474-1_13", bibkey="DBLP:conf/sisap/SchubertG17")
    protected static double estimateInitialBeta(DBIDRef ignore, DoubleDBIDListIter it, double perplexity) {
        double sum = 0.0;
        int size = 0;
        it.seek(0);
        while (it.valid()) {
            if (!DBIDUtil.equal(ignore, it)) {
                sum += it.doubleValue() < Double.POSITIVE_INFINITY ? it.doubleValue() : 0.0;
                ++size;
            }
            it.advance();
        }
        return sum > 0.0 && sum < Double.POSITIVE_INFINITY ? 0.5 / sum * perplexity * ((double)size - 1.0) : 1.0;
    }

    protected static double computeH(DBIDRef ignore, DoubleDBIDListIter it, double[] p, double mbeta) {
        double sumP = 0.0;
        it.seek(0);
        int j = 0;
        while (it.valid()) {
            if (DBIDUtil.equal(ignore, it)) {
                p[j] = 0.0;
            } else {
                p[j] = FastMath.exp(it.doubleValue() * mbeta);
                sumP += p[j];
            }
            ++j;
            it.advance();
        }
        if (!(sumP > 0.0)) {
            return Double.NEGATIVE_INFINITY;
        }
        double s = 1.0 / sumP;
        double sum = 0.0;
        it.seek(0);
        int j2 = 0;
        while (it.valid()) {
            int n = j2++;
            double d = p[n] * s;
            p[n] = d;
            sum += it.doubleValue() * d;
            it.advance();
        }
        return FastMath.log(sumP) - mbeta * sum;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID PERPLEXITY_ID = new OptionID("sos.perplexity", "Perplexity to use.");
        double perplexity = 4.5;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            DoubleParameter perplexityP = (DoubleParameter)new DoubleParameter(PERPLEXITY_ID, 4.5).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(perplexityP)) {
                this.perplexity = perplexityP.doubleValue();
            }
        }

        @Override
        protected SOS<O> makeInstance() {
            return new SOS(this.distanceFunction, this.perplexity);
        }
    }
}

