/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.distance.parallel;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.AbstractDoubleProcessor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedDouble;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedObject;

public class KNNWeightProcessor
extends AbstractDoubleProcessor {
    int k;
    SharedObject<? extends KNNList> input;

    public KNNWeightProcessor(int k) {
        this.k = k;
    }

    public void connectKNNInput(SharedObject<? extends KNNList> input) {
        this.input = input;
    }

    @Override
    public Instance instantiate(Executor executor) {
        return new Instance(this.k, (SharedObject.Instance)((Object)executor.getInstance(this.input)), executor.getInstance(this.output));
    }

    private static class Instance
    extends AbstractDoubleProcessor.Instance {
        int k;
        SharedObject.Instance<? extends KNNList> input;

        protected Instance(int k, SharedObject.Instance<? extends KNNList> input, SharedDouble.Instance store) {
            super(store);
            this.k = k;
            this.input = input;
        }

        @Override
        public void map(DBIDRef id) {
            KNNList list = this.input.get();
            double sum = 0.0;
            DoubleDBIDListIter iter = list.iter();
            for (int i = 0; iter.valid() && i < this.k; ++i) {
                sum += iter.doubleValue();
                iter.advance();
            }
            this.output.set(sum);
        }
    }
}

