/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.intrinsic;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.ALIDEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="IDOS: Intrinsic Dimensional Outlier Score")
@Reference(authors="Jonathan von Br\u00fcnken, Michael E. Houle, Arthur Zimek", title="Intrinsic Dimensional Outlier Detection in High-Dimensional Data", booktitle="NII Technical Report (NII-2015-003E)", url="http://www.nii.ac.jp/TechReports/15-003E.html", bibkey="tr/nii/BrunkenHZ15")
public class IDOS<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(IDOS.class);
    protected int k_c;
    protected int k_r;
    protected IntrinsicDimensionalityEstimator estimator;

    public IDOS(DistanceFunction<? super O> distanceFunction, IntrinsicDimensionalityEstimator estimator, int kc, int kr) {
        super(distanceFunction);
        this.estimator = estimator;
        this.k_c = kc;
        this.k_r = kr;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepprog;
        StepProgress stepProgress = stepprog = LOG.isVerbose() ? new StepProgress("IDOS", 3) : null;
        if (stepprog != null) {
            stepprog.beginStep(1, "Precomputing neighborhoods", LOG);
        }
        KNNQuery<O> knnQ = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), Math.max(this.k_c, this.k_r) + 1);
        DBIDs ids = relation.getDBIDs();
        if (stepprog != null) {
            stepprog.beginStep(2, "Computing intrinsic dimensionalities", LOG);
        }
        DoubleDataStore intDims = this.computeIDs(ids, knnQ);
        if (stepprog != null) {
            stepprog.beginStep(3, "Computing IDOS scores", LOG);
        }
        DoubleMinMax idosminmax = new DoubleMinMax();
        DoubleDataStore ldms = this.computeIDOS(ids, knnQ, intDims, idosminmax);
        if (stepprog != null) {
            stepprog.setCompleted(LOG);
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Intrinsic Dimensionality Outlier Score", "idos", ldms, ids);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(idosminmax.getMin(), idosminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    protected DoubleDataStore computeIDs(DBIDs ids, KNNQuery<O> knnQ) {
        WritableDoubleDataStore intDims = DataStoreUtil.makeDoubleStorage(ids, 3);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Intrinsic dimensionality", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double id = 0.0;
            try {
                id = this.estimator.estimate(knnQ, (DBIDRef)iter, this.k_c + 1);
            }
            catch (ArithmeticException e) {
                id = 0.0;
            }
            intDims.putDouble(iter, id);
            LOG.incrementProcessed(prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
        return intDims;
    }

    protected DoubleDataStore computeIDOS(DBIDs ids, KNNQuery<O> knnQ, DoubleDataStore intDims, DoubleMinMax idosminmax) {
        WritableDoubleDataStore ldms = DataStoreUtil.makeDoubleStorage(ids, 4);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("ID Outlier Scores for objects", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double id_q;
            KNNList neighbors = knnQ.getKNNForDBID(iter, this.k_r);
            double sum = 0.0;
            int cnt = 0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal(iter, neighbor)) {
                    double id = intDims.doubleValue(neighbor);
                    sum += id > 0.0 ? 1.0 / id : 0.0;
                    if (++cnt == this.k_r) break;
                }
                neighbor.advance();
            }
            double idos = (id_q = intDims.doubleValue(iter)) > 0.0 ? id_q * sum / (double)cnt : 0.0;
            ldms.putDouble(iter, idos);
            idosminmax.put(idos);
            LOG.incrementProcessed(prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
        return ldms;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID ESTIMATOR_ID = new OptionID("idos.estimator", "Estimator of intrinsic dimensionality.");
        public static final OptionID KR_ID = new OptionID("idos.kr", "Reference set size.");
        public static final OptionID KC_ID = new OptionID("idos.kc", "Context set size (ID estimation).");
        protected IntrinsicDimensionalityEstimator estimator;
        protected int k_c = 20;
        protected int k_r = 20;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter pKr;
            IntParameter pKc;
            super.makeOptions(config);
            ObjectParameter estP = new ObjectParameter(ESTIMATOR_ID, (Class<?>)IntrinsicDimensionalityEstimator.class, ALIDEstimator.class);
            if (config.grab(estP)) {
                this.estimator = (IntrinsicDimensionalityEstimator)estP.instantiateClass(config);
            }
            if (config.grab(pKc = (IntParameter)new IntParameter(KC_ID).addConstraint((ParameterConstraint)new GreaterEqualConstraint(5)))) {
                this.k_c = (Integer)pKc.getValue();
            }
            if (config.grab(pKr = (IntParameter)new IntParameter(KR_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT))) {
                this.k_r = (Integer)pKr.getValue();
            }
        }

        @Override
        protected IDOS<O> makeInstance() {
            return new IDOS(this.distanceFunction, this.estimator, this.k_c, this.k_r);
        }
    }
}

