/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.intrinsic;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.distance.SOS;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.AggregatedHillEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GreaterEqualConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import net.jafama.FastMath;

@Title(value="ISOS: Intrinsic Stochastic Outlier Selection")
@Reference(authors="Erich Schubert, Michael Gertz", title="Intrinsic t-Stochastic Neighbor Embedding for Visualization and Outlier Detection: A Remedy Against the Curse of Dimensionality?", booktitle="Proc. Int. Conf. Similarity Search and Applications, SISAP'2017", url="https://doi.org/10.1007/978-3-319-68474-1_13", bibkey="DBLP:conf/sisap/SchubertG17")
public class ISOS<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ISOS.class);
    protected int k;
    IntrinsicDimensionalityEstimator estimator;
    protected double phi = 0.01;

    public ISOS(DistanceFunction<? super O> distance, int k, IntrinsicDimensionalityEstimator estimator) {
        super(distance);
        this.k = k;
        this.estimator = estimator;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    public OutlierResult run(Relation<O> relation) {
        int k1 = this.k + 1;
        double perplexity = (double)this.k / 3.0;
        KNNQuery<O> knnq = relation.getKNNQuery(this.getDistanceFunction(), k1);
        double logPerp = perplexity > 1.0 ? FastMath.log(perplexity) : 0.1;
        double[] p = new double[this.k + 10];
        ModifiableDoubleDBIDList dists = DBIDUtil.newDistanceDBIDList(this.k + 10);
        DoubleDBIDListMIter di = dists.iter();
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("ISOS scores", relation.size(), LOG) : null;
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30, 1.0);
        DBIDIter it = relation.iterDBIDs();
        while (it.valid()) {
            block5: {
                KNNList knns = knnq.getKNNForDBID(it, k1);
                if (p.length < knns.size() + 1) {
                    p = new double[knns.size() + 10];
                }
                DoubleDBIDListIter ki = knns.iter();
                try {
                    double id = this.estimateID(it, ki, p);
                    ISOS.adjustDistances(it, ki, knns.getKNNDistance(), id, dists);
                    SOS.computePi(it, di, p, perplexity, logPerp);
                    double s = SOS.sumOfProbabilities(it, di, p);
                    if (s > 0.0) {
                        ISOS.nominateNeighbors(it, di, p, 1.0 / s, scores);
                    }
                }
                catch (ArithmeticException e) {
                    SOS.computePi(it, ki, p, perplexity, logPerp);
                    double s = SOS.sumOfProbabilities(it, ki, p);
                    if (!(s > 0.0)) break block5;
                    ISOS.nominateNeighbors(it, ki, p, 1.0 / s, scores);
                }
            }
            LOG.incrementProcessed(prog);
            it.advance();
        }
        LOG.ensureCompleted(prog);
        DoubleMinMax minmax = ISOS.transformScores(scores, relation.getDBIDs(), logPerp, this.phi);
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Intrinsic Stoachastic Outlier Selection", "isos-outlier", scores, relation.getDBIDs());
        ProbabilisticOutlierScore meta = new ProbabilisticOutlierScore(minmax.getMin(), minmax.getMax(), 0.0);
        return new OutlierResult(meta, scoreres);
    }

    protected static void adjustDistances(DBIDRef ignore, DoubleDBIDListIter ki, double max, double id, ModifiableDoubleDBIDList dists) {
        dists.clear();
        double scaleexp = id * 0.5;
        double scalelin = 1.0 / max;
        ki.seek(0);
        while (ki.valid()) {
            if (!DBIDUtil.equal(ignore, ki)) {
                double d = FastMath.pow(ki.doubleValue() * scalelin, scaleexp);
                dists.add(d, ki);
            }
            ki.advance();
        }
    }

    protected double estimateID(DBIDRef ignore, DoubleDBIDListIter it, double[] p) {
        int j = 0;
        it.seek(0);
        while (it.valid()) {
            if (it.doubleValue() != 0.0 && !DBIDUtil.equal(ignore, it)) {
                p[j++] = it.doubleValue();
            }
            it.advance();
        }
        if (j < 2) {
            throw new ArithmeticException("Too little data to estimate ID.");
        }
        return this.estimator.estimate(p, j);
    }

    public static void nominateNeighbors(DBIDIter ignore, DBIDArrayIter di, double[] p, double norm, WritableDoubleDataStore scores) {
        di.seek(0);
        while (di.valid()) {
            if (!DBIDUtil.equal(ignore, di)) {
                double v = p[di.getOffset()] * norm;
                if (!(v > 0.0)) break;
                scores.increment(di, FastMath.log1p(-v));
            }
            di.advance();
        }
    }

    public static DoubleMinMax transformScores(WritableDoubleDataStore scores, DBIDs ids, double logPerp, double phi) {
        DoubleMinMax minmax = new DoubleMinMax();
        double adj = (1.0 - phi) / phi;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            double or = FastMath.exp(-scores.doubleValue(it) * logPerp) * adj;
            double s = 1.0 / (1.0 + or);
            scores.putDouble(it, s);
            minmax.put(s);
            it.advance();
        }
        return minmax;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID KNN_ID = new OptionID("isos.k", "Number of neighbors to use. Should be about 3x the desired perplexity.");
        public static final OptionID ESTIMATOR_ID = new OptionID("isos.estimator", "Estimator for intrinsic dimensionality.");
        int k = 15;
        IntrinsicDimensionalityEstimator estimator = AggregatedHillEstimator.STATIC;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter estimatorP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(KNN_ID, 100).addConstraint((ParameterConstraint)new GreaterEqualConstraint(5));
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
            if (config.grab(estimatorP = new ObjectParameter(ESTIMATOR_ID, (Class<?>)IntrinsicDimensionalityEstimator.class, AggregatedHillEstimator.class))) {
                this.estimator = (IntrinsicDimensionalityEstimator)estimatorP.instantiateClass(config);
            }
        }

        @Override
        protected ISOS<O> makeInstance() {
            return new ISOS(this.distanceFunction, this.k, this.estimator);
        }
    }
}

