/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.intrinsic;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.IntrinsicDimensionalityEstimator;
import de.lmu.ifi.dbs.elki.math.statistics.intrinsicdimensionality.MOMEstimator;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Reference(authors="Michael E. Houle, Erich Schubert, Arthur Zimek", title="On the Correlation Between Local Intrinsic Dimensionality and Outlierness", booktitle="Proc. 11th Int. Conf. Similarity Search and Applications (SISAP'2018)", bibkey="DBLP:conf/sisap/HouleSZ18")
public class IntrinsicDimensionalityOutlier<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(IntrinsicDimensionalityOutlier.class);
    protected int k;
    protected IntrinsicDimensionalityEstimator estimator;

    public IntrinsicDimensionalityOutlier(DistanceFunction<? super O> distanceFunction, int k, IntrinsicDimensionalityEstimator estimator) {
        super(distanceFunction);
        this.k = k;
        this.estimator = estimator;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distanceQuery = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnQuery = database.getKNNQuery(distanceQuery, this.k + 1);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("kNN distance for objects", relation.size(), LOG) : null;
        DoubleMinMax minmax = new DoubleMinMax();
        WritableDoubleDataStore id_score = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double id = 0.0;
            try {
                id = this.estimator.estimate(knnQuery, (DBIDRef)iditer, this.k + 1);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            id_score.putDouble(iditer, id);
            minmax.put(id);
            LOG.incrementProcessed(prog);
            iditer.advance();
        }
        LOG.ensureCompleted(prog);
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Intrinsic dimensionality", "id-score", id_score, relation.getDBIDs());
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(meta, scoreres);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("id.k", "Number of nearest neighbors to use for ID estimation (usually 20-100).");
        public static final OptionID ESTIMATOR_ID = new OptionID("id.estimator", "Class to estimate ID from distance distribution.");
        protected int k;
        protected IntrinsicDimensionalityEstimator estimator;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter estP;
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
            if (config.grab(estP = new ObjectParameter(ESTIMATOR_ID, (Class<?>)IntrinsicDimensionalityEstimator.class, MOMEstimator.class))) {
                this.estimator = (IntrinsicDimensionalityEstimator)estP.instantiateClass(config);
            }
        }

        @Override
        protected IntrinsicDimensionalityOutlier<O> makeInstance() {
            return new IntrinsicDimensionalityOutlier(this.distanceFunction, this.k, this.estimator);
        }
    }
}

