/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.jafama.FastMath;

@Title(value="Approximate LOCI: Fast Outlier Detection Using the Local Correlation Integral")
@Description(value="Algorithm to compute outliers based on the Local Correlation Integral")
@Reference(authors="S. Papadimitriou, H. Kitagawa, P. B. Gibbons, C. Faloutsos", title="LOCI: Fast Outlier Detection Using the Local Correlation Integral", booktitle="Proc. 19th IEEE Int. Conf. on Data Engineering (ICDE '03)", url="https://doi.org/10.1109/ICDE.2003.1260802", bibkey="DBLP:conf/icde/PapadimitriouKGF03")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.ALOCI"})
public class ALOCI<O extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ALOCI.class);
    private int nmin;
    private int alpha;
    private int g;
    private RandomFactory rnd;
    private NumberVectorDistanceFunction<?> distFunc;

    public ALOCI(NumberVectorDistanceFunction<?> distanceFunction, int nmin, int alpha, int g, RandomFactory rnd) {
        this.distFunc = distanceFunction;
        this.nmin = nmin;
        this.alpha = alpha;
        this.g = g;
        this.rnd = rnd;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        int i;
        int dim = RelationUtil.dimensionality(relation);
        Random random = this.rnd.getSingleThreadedRandom();
        FiniteProgress progressPreproc = LOG.isVerbose() ? new FiniteProgress("Build aLOCI quadtress", this.g, LOG) : null;
        double[][] hbbs = RelationUtil.computeMinMax(relation);
        double[] min = hbbs[0];
        double[] max = hbbs[1];
        double maxd = 0.0;
        for (i = 0; i < dim; ++i) {
            maxd = MathUtil.max(maxd, max[i] - min[i]);
        }
        i = 0;
        while (i < dim) {
            double diff = (maxd - (max[i] - min[i])) * 0.5;
            int n = i;
            min[n] = min[n] - diff;
            int n2 = i++;
            max[n2] = max[n2] + diff;
        }
        ArrayList<ALOCIQuadTree> qts = new ArrayList<ALOCIQuadTree>(this.g);
        double[] nshift = new double[dim];
        ALOCIQuadTree qt = new ALOCIQuadTree(min, max, nshift, this.nmin, relation);
        qts.add(qt);
        LOG.incrementProcessed(progressPreproc);
        for (int shift = 1; shift < this.g; ++shift) {
            double[] svec = new double[dim];
            for (int i2 = 0; i2 < dim; ++i2) {
                svec[i2] = random.nextDouble() * (max[i2] - min[i2]);
            }
            qt = new ALOCIQuadTree(min, max, svec, this.nmin, relation);
            qts.add(qt);
            LOG.incrementProcessed(progressPreproc);
        }
        LOG.ensureCompleted(progressPreproc);
        FiniteProgress progressLOCI = LOG.isVerbose() ? new FiniteProgress("Compute aLOCI scores", relation.size(), LOG) : null;
        WritableDoubleDataStore mdef_norm = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            NumberVector obj = (NumberVector)relation.get(iditer);
            double maxmdefnorm = 0.0;
            int l = 0;
            while (true) {
                Node ci = null;
                for (int i3 = 0; i3 < this.g; ++i3) {
                    Node ci2 = ((ALOCIQuadTree)qts.get(i3)).findClosestNode(obj, l);
                    if (ci2.getLevel() != l || ci != null && !(this.distFunc.distance(ci, obj) > this.distFunc.distance(ci2, obj))) continue;
                    ci = ci2;
                }
                if (ci == null) break;
                Node cj = null;
                for (int i4 = 0; i4 < this.g; ++i4) {
                    Node cj2 = ((ALOCIQuadTree)qts.get(i4)).findClosestNode(ci, l - this.alpha);
                    if (cj != null && cj2.getLevel() < cj.getLevel() || cj != null && !(this.distFunc.distance(cj, ci) > this.distFunc.distance(cj2, ci))) continue;
                    cj = cj2;
                }
                if (cj != null) {
                    double mdefnorm = ALOCI.calculate_MDEF_norm(cj, ci);
                    maxmdefnorm = MathUtil.max(maxmdefnorm, mdefnorm);
                }
                ++l;
            }
            mdef_norm.putDouble(iditer, maxmdefnorm);
            minmax.put(maxmdefnorm);
            LOG.incrementProcessed(progressLOCI);
            iditer.advance();
        }
        LOG.ensureCompleted(progressLOCI);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("aLOCI normalized MDEF", "aloci-mdef-outlier", mdef_norm, relation.getDBIDs());
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY);
        OutlierResult result = new OutlierResult(scoreMeta, scoreResult);
        return result;
    }

    private static double calculate_MDEF_norm(Node sn, Node cg) {
        long sq = sn.getSquareSum(cg.getLevel() - sn.getLevel());
        if (sq == (long)sn.getCount()) {
            return 0.0;
        }
        long cb = sn.getCubicSum(cg.getLevel() - sn.getLevel());
        double n_hat = (double)sq / (double)sn.getCount();
        double sig_n_hat = FastMath.sqrt(cb * (long)sn.getCount() - sq * sq) / (double)sn.getCount();
        if (sig_n_hat < Double.MIN_NORMAL) {
            return 0.0;
        }
        double mdef = n_hat - (double)cg.getCount();
        return mdef / sig_n_hat;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.distFunc.getInputTypeRestriction());
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractParameterizer {
        public static final OptionID NMIN_ID = new OptionID("loci.nmin", "Minimum neighborhood size to be considered.");
        public static final OptionID ALPHA_ID = new OptionID("loci.alpha", "Scaling factor for averaging neighborhood");
        public static final OptionID GRIDS_ID = new OptionID("loci.g", "The number of Grids to use.");
        public static final OptionID SEED_ID = new OptionID("loci.seed", "The seed to use for initializing Random.");
        protected int nmin = 0;
        protected int alpha = 4;
        protected int g = 1;
        protected RandomFactory rnd;
        private NumberVectorDistanceFunction<?> distanceFunction;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter alphaP;
            RandomParameter rndP;
            IntParameter g;
            IntParameter nminP;
            super.makeOptions(config);
            ObjectParameter distanceFunctionP = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)NumberVectorDistanceFunction.class, EuclideanDistanceFunction.class);
            if (config.grab(distanceFunctionP)) {
                this.distanceFunction = (NumberVectorDistanceFunction)distanceFunctionP.instantiateClass(config);
            }
            if (config.grab(nminP = new IntParameter(NMIN_ID, 20))) {
                this.nmin = (Integer)nminP.getValue();
            }
            if (config.grab(g = new IntParameter(GRIDS_ID, 1))) {
                this.g = (Integer)g.getValue();
            }
            if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
            if (config.grab(alphaP = new IntParameter(ALPHA_ID, 4))) {
                this.alpha = (Integer)alphaP.getValue();
                if (this.alpha < 1) {
                    this.alpha = 1;
                }
            }
        }

        @Override
        protected ALOCI<O> makeInstance() {
            return new ALOCI(this.distanceFunction, this.nmin, this.alpha, this.g, this.rnd);
        }
    }

    static class Node
    implements NumberVector {
        final int code;
        final int count;
        final int level;
        List<Node> children;
        Node parent = null;
        double[] center;

        protected Node(int code, double[] center, int count, int level, List<Node> children) {
            this.code = code;
            this.center = center;
            this.count = count;
            this.level = level;
            this.children = children;
            if (children != null) {
                for (Node child : children) {
                    child.parent = this;
                }
            }
        }

        public int getLevel() {
            return this.level;
        }

        public int getCount() {
            return this.count;
        }

        public long getSquareSum(int levels) {
            if (levels <= 0 || this.children == null) {
                return (long)this.count * (long)this.count;
            }
            long agg = 0L;
            for (Node child : this.children) {
                agg += child.getSquareSum(levels - 1);
            }
            return agg;
        }

        public long getCubicSum(int levels) {
            if (levels <= 0 || this.children == null) {
                return (long)this.count * (long)this.count * (long)this.count;
            }
            long agg = 0L;
            for (Node child : this.children) {
                agg += child.getCubicSum(levels - 1);
            }
            return agg;
        }

        @Override
        public int getDimensionality() {
            return this.center.length;
        }

        @Override
        public double doubleValue(int dimension) {
            return this.center[dimension];
        }

        @Override
        public long longValue(int dimension) {
            return (long)this.center[dimension];
        }

        @Override
        public double[] toArray() {
            return (double[])this.center.clone();
        }
    }

    static class ALOCIQuadTree {
        private double[] shift;
        private double[] min;
        private double[] width;
        private int nmin;
        Node root;
        private Relation<? extends NumberVector> relation;

        public ALOCIQuadTree(double[] min, double[] max, double[] shift, int nmin, Relation<? extends NumberVector> relation) {
            assert (min.length <= 32) : "Quadtrees are only supported for up to 32 dimensions";
            this.shift = shift;
            this.nmin = nmin;
            this.min = min;
            this.width = new double[min.length];
            for (int d = 0; d < min.length; ++d) {
                this.width[d] = max[d] - min[d];
                if (!(this.width[d] <= 0.0)) continue;
                this.width[d] = 1.0;
            }
            double[] center = new double[min.length];
            for (int d = 0; d < min.length; ++d) {
                center[d] = shift[d] < this.width[d] * 0.5 ? min[d] + shift[d] + this.width[d] * 0.5 : min[d] + shift[d] - this.width[d] * 0.5;
            }
            this.relation = relation;
            ArrayModifiableDBIDs ids = DBIDUtil.newArray(relation.getDBIDs());
            ArrayList<Node> children = new ArrayList<Node>();
            this.bulkLoad((double[])min.clone(), (double[])max.clone(), children, ids, 0, ids.size(), 0, 0, 0);
            this.root = new Node(0, center, ids.size(), -1, children);
        }

        private void bulkLoad(double[] lmin, double[] lmax, List<Node> children, ArrayModifiableDBIDs ids, int start, int end, int dim, int level, int code) {
            if (dim == 0) {
                int d;
                DBIDArrayMIter iter = ids.iter();
                iter.seek(start);
                NumberVector first = this.relation.get(iter);
                iter.advance();
                boolean degenerate = true;
                block0: while (iter.getOffset() < end) {
                    NumberVector other = this.relation.get(iter);
                    for (d = 0; d < lmin.length; ++d) {
                        if (!(Math.abs(first.doubleValue(d) - other.doubleValue(d)) > 1.0E-15)) continue;
                        degenerate = false;
                        break block0;
                    }
                    iter.advance();
                }
                if (degenerate) {
                    double[] center = new double[lmin.length];
                    for (d = 0; d < lmin.length; ++d) {
                        center[d] = lmin[d] * 0.5 + lmax[d] * 0.5 + this.shift[d];
                        if (!(center[d] > this.min[d] + this.width[d])) continue;
                        int n = d;
                        center[n] = center[n] - this.width[d];
                    }
                    children.add(new Node(code, center, end - start, level, null));
                    return;
                }
            }
            if (dim == lmin.length) {
                double[] center = new double[lmin.length];
                for (int d = 0; d < lmin.length; ++d) {
                    center[d] = lmin[d] * 0.5 + lmax[d] * 0.5 + this.shift[d];
                    if (!(center[d] > this.min[d] + this.width[d])) continue;
                    int n = d;
                    center[n] = center[n] - this.width[d];
                }
                if (end - start < this.nmin) {
                    children.add(new Node(code, center, end - start, level, null));
                    return;
                }
                ArrayList<Node> newchildren = new ArrayList<Node>();
                this.bulkLoad(lmin, lmax, newchildren, ids, start, end, 0, level + 1, 0);
                children.add(new Node(code, center, end - start, level, newchildren));
                return;
            }
            DBIDArrayMIter siter = ids.iter();
            DBIDArrayMIter eiter = ids.iter();
            siter.seek(start);
            eiter.seek(end - 1);
            while (siter.getOffset() < eiter.getOffset()) {
                if (this.getShiftedDim(this.relation.get(siter), dim, level) <= 0.5) {
                    siter.advance();
                    continue;
                }
                if (this.getShiftedDim(this.relation.get(eiter), dim, level) > 0.5) {
                    eiter.retract();
                    continue;
                }
                ids.swap(siter.getOffset(), eiter.getOffset() - 1);
                siter.advance();
                eiter.retract();
            }
            int spos = siter.getOffset();
            if (start < spos) {
                double tmp = lmax[dim];
                lmax[dim] = lmax[dim] * 0.5 + lmin[dim] * 0.5;
                this.bulkLoad(lmin, lmax, children, ids, start, spos, dim + 1, level, code);
                lmax[dim] = tmp;
            }
            if (spos < end) {
                double tmp = lmin[dim];
                lmin[dim] = lmax[dim] * 0.5 + lmin[dim] * 0.5;
                this.bulkLoad(lmin, lmax, children, ids, spos, end, dim + 1, level, code | 1 << dim);
                lmin[dim] = tmp;
            }
        }

        private double getShiftedDim(NumberVector obj, int dim, int level) {
            double pos = obj.doubleValue(dim) + this.shift[dim];
            pos = (pos - this.min[dim]) / this.width[dim] * (double)(1 + level);
            return pos - FastMath.floor(pos);
        }

        public Node findClosestNode(NumberVector vec, int tlevel) {
            Node cur = this.root;
            for (int level = 0; level <= tlevel && cur.children != null; ++level) {
                int code = 0;
                for (int d = 0; d < this.min.length; ++d) {
                    if (!(this.getShiftedDim(vec, d, level) > 0.5)) continue;
                    code |= 1 << d;
                }
                boolean found = false;
                for (Node child : cur.children) {
                    if (child.code != code) continue;
                    cur = child;
                    found = true;
                    break;
                }
                if (!found) break;
            }
            return cur;
        }
    }
}

