/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="COF: Connectivity-based Outlier Factor")
@Reference(authors="J. Tang, Z. Chen, A. W. C. Fu, D. W. Cheung", title="Enhancing effectiveness of outlier detections for low density patterns", booktitle="In Advances in Knowledge Discovery and Data Mining", url="https://doi.org/10.1007/3-540-47887-6_53", bibkey="DBLP:conf/pakdd/TangCFC02")
public class COF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(COF.class);
    protected int k;

    public COF(int k, DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
        this.k = k + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("COF", 3) : null;
        DistanceQuery<O> dq = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        LOG.beginStep(stepprog, 1, "Materializing COF neighborhoods.");
        KNNQuery<O> knnq = DatabaseUtil.precomputedKNNQuery(database, relation, dq, this.k);
        DBIDs ids = relation.getDBIDs();
        LOG.beginStep(stepprog, 2, "Computing Average Chaining Distances.");
        WritableDoubleDataStore acds = DataStoreUtil.makeDoubleStorage(ids, 3);
        this.computeAverageChainingDistances(knnq, dq, ids, acds);
        LOG.beginStep(stepprog, 3, "Computing Connectivity-based Outlier Factors.");
        WritableDoubleDataStore cofs = DataStoreUtil.makeDoubleStorage(ids, 30);
        DoubleMinMax cofminmax = new DoubleMinMax();
        this.computeCOFScores(knnq, ids, acds, cofs, cofminmax);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Connectivity-Based Outlier Factor", "cof-outlier", cofs, ids);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(cofminmax.getMin(), cofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    protected void computeAverageChainingDistances(KNNQuery<O> knnq, DistanceQuery<O> dq, DBIDs ids, WritableDoubleDataStore acds) {
        FiniteProgress lrdsProgress = LOG.isVerbose() ? new FiniteProgress("Computing average chaining distances", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNNForDBID(iter, this.k);
            int r = neighbors.size();
            DoubleDBIDListIter it1 = neighbors.iter();
            DoubleDBIDListIter it2 = neighbors.iter();
            double[] mindists = new double[r];
            int i = 0;
            while (it1.valid()) {
                mindists[i] = DBIDUtil.equal(it1, iter) ? Double.NaN : it1.doubleValue();
                it1.advance();
                ++i;
            }
            double acsum = 0.0;
            for (int j = (r < this.k ? r : this.k) - 1; j > 0; --j) {
                double curdist;
                int i2;
                int minpos = -1;
                double mindist = Double.NaN;
                for (i2 = 0; i2 < mindists.length; ++i2) {
                    curdist = mindists[i2];
                    if (curdist != curdist || curdist > mindist) continue;
                    minpos = i2;
                    mindist = curdist;
                }
                acsum += mindist * (double)j;
                mindists[minpos] = Double.NaN;
                it1.seek(minpos);
                it2.seek(0);
                i2 = 0;
                while (it2.valid()) {
                    double newdist;
                    curdist = mindists[i2];
                    if (curdist == curdist && (newdist = dq.distance((DBIDRef)it1, (DBIDRef)it2)) < curdist) {
                        mindists[i2] = newdist;
                    }
                    it2.advance();
                    ++i2;
                }
            }
            acds.putDouble(iter, acsum / ((double)r * 0.5 * ((double)r - 1.0)));
            LOG.incrementProcessed(lrdsProgress);
            iter.advance();
        }
        LOG.ensureCompleted(lrdsProgress);
    }

    private void computeCOFScores(KNNQuery<O> knnq, DBIDs ids, DoubleDataStore acds, WritableDoubleDataStore cofs, DoubleMinMax cofminmax) {
        FiniteProgress progressCOFs = LOG.isVerbose() ? new FiniteProgress("COF for objects", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNNForDBID(iter, this.k);
            double sum = 0.0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal(neighbor, iter)) {
                    sum += acds.doubleValue(neighbor);
                }
                neighbor.advance();
            }
            double cof = sum > 0.0 ? acds.doubleValue(iter) * (double)this.k / sum : (acds.doubleValue(iter) > 0.0 ? Double.POSITIVE_INFINITY : 1.0);
            cofs.putDouble(iter, cof);
            cofminmax.put(cof);
            LOG.incrementProcessed(progressCOFs);
            iter.advance();
        }
        LOG.ensureCompleted(progressCOFs);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("cof.k", "The number of neighbors (not including the query object) to use for computing the COF score.");
        protected int k;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter pK = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(pK)) {
                this.k = pK.intValue();
            }
        }

        @Override
        protected COF<O> makeInstance() {
            return new COF(this.k, this.distanceFunction);
        }
    }
}

