/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.PreprocessorKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;

@Title(value="FlexibleLOF: Local Outlier Factor with additional options")
@Description(value="Algorithm to compute density-based local outlier factors in a database based on the neighborhood size parameter 'k'")
@Reference(authors="Markus M. Breunig, Hans-Peter Kriegel, Raymond Ng, J\u00f6rg Sander", title="LOF: Identifying Density-Based Local Outliers", booktitle="Proc. 2nd ACM SIGMOD Int. Conf. on Management of Data (SIGMOD'00)", url="https://doi.org/10.1145/342009.335388", bibkey="DBLP:conf/sigmod/BreunigKNS00")
public class FlexibleLOF<O>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(FlexibleLOF.class);
    protected int krefer = 2;
    protected int kreach = 2;
    protected DistanceFunction<? super O> referenceDistanceFunction;
    protected DistanceFunction<? super O> reachabilityDistanceFunction;

    public FlexibleLOF(int krefer, int kreach, DistanceFunction<? super O> neighborhoodDistanceFunction, DistanceFunction<? super O> reachabilityDistanceFunction) {
        this.krefer = krefer + 1;
        this.kreach = kreach + 1;
        this.referenceDistanceFunction = neighborhoodDistanceFunction;
        this.reachabilityDistanceFunction = reachabilityDistanceFunction;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("LOF", 3) : null;
        Pair<KNNQuery<O>, KNNQuery<O>> pair = this.getKNNQueries(database, relation, stepprog);
        KNNQuery<O> kNNRefer = pair.getFirst();
        KNNQuery<O> kNNReach = pair.getSecond();
        return this.doRunInTime(relation.getDBIDs(), kNNRefer, kNNReach, stepprog).getResult();
    }

    private Pair<KNNQuery<O>, KNNQuery<O>> getKNNQueries(Database database, Relation<O> relation, StepProgress stepprog) {
        DistanceQuery<? super O> distQ = database.getDistanceQuery(relation, this.reachabilityDistanceFunction, "heavy");
        KNNQuery<? super O> knnReach = database.getKNNQuery(distQ, this.kreach, "heavy", "optimized", "no-cache");
        if (!(knnReach instanceof PreprocessorKNNQuery)) {
            if (stepprog != null) {
                if (this.referenceDistanceFunction.equals(this.reachabilityDistanceFunction)) {
                    stepprog.beginStep(1, "Materializing neighborhoods w.r.t. reference neighborhood distance function.", LOG);
                } else {
                    stepprog.beginStep(1, "Not materializing neighborhoods w.r.t. reference neighborhood distance function, but materializing neighborhoods w.r.t. reachability distance function.", LOG);
                }
            }
            int kpreproc = this.referenceDistanceFunction.equals(this.reachabilityDistanceFunction) ? Math.max(this.kreach, this.krefer) : this.kreach;
            knnReach = DatabaseUtil.precomputedKNNQuery(database, relation, this.reachabilityDistanceFunction, kpreproc);
        }
        KNNQuery<? super O> knnRefer = this.referenceDistanceFunction == this.reachabilityDistanceFunction || this.referenceDistanceFunction.equals(this.reachabilityDistanceFunction) ? knnReach : QueryUtil.getKNNQuery(relation, this.referenceDistanceFunction, this.krefer);
        return new Pair<KNNQuery<O>, KNNQuery<O>>(knnRefer, knnReach);
    }

    protected LOFResult<O> doRunInTime(DBIDs ids, KNNQuery<O> kNNRefer, KNNQuery<O> kNNReach, StepProgress stepprog) {
        if (kNNRefer == null) {
            throw new AbortException("No kNN queries supported by database for reference neighborhood distance function.");
        }
        if (kNNReach == null) {
            throw new AbortException("No kNN queries supported by database for reachability distance function.");
        }
        LOG.beginStep(stepprog, 2, "Computing LRDs.");
        WritableDoubleDataStore lrds = DataStoreUtil.makeDoubleStorage(ids, 3);
        this.computeLRDs(kNNReach, ids, lrds);
        LOG.beginStep(stepprog, 3, "Computing LOFs.");
        WritableDoubleDataStore lofs = DataStoreUtil.makeDoubleStorage(ids, 4);
        DoubleMinMax lofminmax = new DoubleMinMax();
        this.computeLOFs(kNNRefer, ids, lrds, lofs, lofminmax);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Local Outlier Factor", "lof-outlier", lofs, ids);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(lofminmax.getMin(), lofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult result = new OutlierResult(scoreMeta, scoreResult);
        return new LOFResult<O>(result, kNNRefer, kNNReach, lrds, lofs);
    }

    protected void computeLRDs(KNNQuery<O> knnq, DBIDs ids, WritableDoubleDataStore lrds) {
        FiniteProgress lrdsProgress = LOG.isVerbose() ? new FiniteProgress("LRD", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNNForDBID(iter, this.kreach);
            double sum = 0.0;
            int count = 0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal(neighbor, iter)) {
                    KNNList neighborsNeighbors = knnq.getKNNForDBID(neighbor, this.kreach);
                    sum += MathUtil.max(neighbor.doubleValue(), neighborsNeighbors.getKNNDistance());
                    ++count;
                }
                neighbor.advance();
            }
            double lrd = sum > 0.0 ? (double)count / sum : Double.POSITIVE_INFINITY;
            lrds.putDouble(iter, lrd);
            LOG.incrementProcessed(lrdsProgress);
            iter.advance();
        }
        LOG.ensureCompleted(lrdsProgress);
    }

    protected void computeLOFs(KNNQuery<O> knnq, DBIDs ids, DoubleDataStore lrds, WritableDoubleDataStore lofs, DoubleMinMax lofminmax) {
        FiniteProgress progressLOFs = LOG.isVerbose() ? new FiniteProgress("LOF_SCORE for objects", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double lof;
            double lrdp = lrds.doubleValue(iter);
            KNNList neighbors = knnq.getKNNForDBID(iter, this.krefer);
            if (!Double.isInfinite(lrdp)) {
                double sum = 0.0;
                int count = 0;
                DoubleDBIDListIter neighbor = neighbors.iter();
                while (neighbor.valid()) {
                    if (!DBIDUtil.equal(neighbor, iter)) {
                        double val = lrds.doubleValue(neighbor);
                        sum += val;
                        ++count;
                        if (Double.isInfinite(val)) break;
                    }
                    neighbor.advance();
                }
                lof = sum / (lrdp * (double)count);
            } else {
                lof = 1.0;
            }
            lofs.putDouble(iter, lof);
            lofminmax.put(lof);
            LOG.incrementProcessed(progressLOFs);
            iter.advance();
        }
        LOG.ensureCompleted(progressLOFs);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        TypeInformation type = this.reachabilityDistanceFunction.equals(this.referenceDistanceFunction) ? this.reachabilityDistanceFunction.getInputTypeRestriction() : new CombinedTypeInformation(this.referenceDistanceFunction.getInputTypeRestriction(), this.reachabilityDistanceFunction.getInputTypeRestriction());
        return TypeUtil.array(type);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID REACHABILITY_DISTANCE_FUNCTION_ID = new OptionID("lof.reachdistfunction", "Distance function to determine the reachability distance between database objects.");
        public static final OptionID KREF_ID = new OptionID("lof.krefer", "The number of nearest neighbors of an object to be considered for computing its LOF score.");
        public static final OptionID KREACH_ID = new OptionID("lof.kreach", "The number of nearest neighbors of an object to be considered for computing its LOF score.");
        protected int krefer = 2;
        protected int kreach = 2;
        protected DistanceFunction<? super O> neighborhoodDistanceFunction = null;
        protected DistanceFunction<? super O> reachabilityDistanceFunction = null;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter pK2;
            super.makeOptions(config);
            IntParameter pK = (IntParameter)new IntParameter(KREF_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(pK)) {
                this.krefer = pK.intValue();
            }
            this.kreach = config.grab(pK2 = (IntParameter)((IntParameter)new IntParameter(KREACH_ID).setOptional(true)).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)) ? pK2.intValue() : this.krefer;
            ObjectParameter reachDistP = new ObjectParameter(REACHABILITY_DISTANCE_FUNCTION_ID, DistanceFunction.class);
            reachDistP.setOptional(true);
            this.reachabilityDistanceFunction = config.grab(reachDistP) ? (DistanceFunction)reachDistP.instantiateClass(config) : this.distanceFunction;
        }

        @Override
        protected FlexibleLOF<O> makeInstance() {
            return new FlexibleLOF<O>(this.kreach, this.krefer, this.distanceFunction, this.reachabilityDistanceFunction);
        }
    }

    public static class LOFResult<O> {
        private OutlierResult result;
        private final KNNQuery<O> kNNRefer;
        private final KNNQuery<O> kNNReach;
        private RKNNQuery<O> rkNNRefer;
        private RKNNQuery<O> rkNNReach;
        private final WritableDoubleDataStore lrds;
        private final WritableDoubleDataStore lofs;

        public LOFResult(OutlierResult result, KNNQuery<O> kNNRefer, KNNQuery<O> kNNReach, WritableDoubleDataStore lrds, WritableDoubleDataStore lofs) {
            this.result = result;
            this.kNNRefer = kNNRefer;
            this.kNNReach = kNNReach;
            this.lrds = lrds;
            this.lofs = lofs;
        }

        public KNNQuery<O> getKNNRefer() {
            return this.kNNRefer;
        }

        public KNNQuery<O> getKNNReach() {
            return this.kNNReach;
        }

        public WritableDoubleDataStore getLrds() {
            return this.lrds;
        }

        public WritableDoubleDataStore getLofs() {
            return this.lofs;
        }

        public OutlierResult getResult() {
            return this.result;
        }

        public void setRkNNRefer(RKNNQuery<O> rkNNRefer) {
            this.rkNNRefer = rkNNRefer;
        }

        public RKNNQuery<O> getRkNNRefer() {
            return this.rkNNRefer;
        }

        public RKNNQuery<O> getRkNNReach() {
            return this.rkNNReach;
        }

        public void setRkNNReach(RKNNQuery<O> rkNNReach) {
            this.rkNNReach = rkNNReach;
        }
    }
}

