/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="INFLO: Influenced Outlierness Factor")
@Description(value="Ranking Outliers Using Symmetric Neigborhood Relationship")
@Reference(authors="W. Jin, A. Tung, J. Han, W. Wang", title="Ranking outliers using symmetric neighborhood relationship", booktitle="Proc. 10th Pacific-Asia conference on Advances in Knowledge Discovery and Data Mining", url="https://doi.org/10.1007/11731139_68", bibkey="DBLP:conf/pakdd/JinTHW06")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.INFLO"})
public class INFLO<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(INFLO.class);
    private double m;
    private int kplus1;

    public INFLO(DistanceFunction<? super O> distanceFunction, double m, int k) {
        super(distanceFunction);
        this.m = m;
        this.kplus1 = k + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("INFLO", 3) : null;
        LOG.beginStep(stepprog, 1, "Materializing nearest-neighbor sets.");
        KNNQuery<O> knnq = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.kplus1);
        LOG.beginStep(stepprog, 2, "Materialize reverse NN.");
        HashSetModifiableDBIDs pruned = DBIDUtil.newHashSet();
        WritableDataStore<SetDBIDs> knns = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, SetDBIDs.class);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            knns.put(iditer, DBIDUtil.ensureSet(knnq.getKNNForDBID(iditer, this.kplus1)));
            iditer.advance();
        }
        WritableDataStore<ModifiableDBIDs> rnnMinusKNNs = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, ModifiableDBIDs.class);
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            rnnMinusKNNs.put(iditer2, DBIDUtil.newArray());
            iditer2.advance();
        }
        this.computeNeighborhoods(relation, knns, pruned, rnnMinusKNNs);
        knns.clear();
        LOG.beginStep(stepprog, 3, "Compute INFLO scores.");
        DoubleMinMax inflominmax = new DoubleMinMax();
        WritableDoubleDataStore inflos = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        this.computeINFLO(relation, pruned, knnq, rnnMinusKNNs, inflos, inflominmax);
        LOG.setCompleted(stepprog);
        LOG.statistics(new LongStatistic(INFLO.class.getName() + ".pruned", pruned.size()));
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Influence Outlier Score", "inflo-outlier", inflos, relation.getDBIDs());
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(inflominmax.getMin(), inflominmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    private void computeNeighborhoods(Relation<O> relation, DataStore<SetDBIDs> knns, ModifiableDBIDs pruned, WritableDataStore<ModifiableDBIDs> rNNminuskNNs) {
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Finding RkNN", relation.size(), LOG) : null;
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            DBIDs knn = knns.get(iter);
            int count = 1;
            DBIDIter niter = knn.iter();
            while (niter.valid()) {
                if (!DBIDUtil.equal(iter, niter)) {
                    if (knns.get(niter).contains(iter)) {
                        ++count;
                    } else {
                        ((ModifiableDBIDs)rNNminuskNNs.get(niter)).add(iter);
                    }
                }
                niter.advance();
            }
            if ((double)count >= (double)knn.size() * this.m) {
                pruned.add(iter);
            }
            LOG.incrementProcessed(prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
    }

    protected void computeINFLO(Relation<O> relation, ModifiableDBIDs pruned, KNNQuery<O> knnq, WritableDataStore<ModifiableDBIDs> rNNminuskNNs, WritableDoubleDataStore inflos, DoubleMinMax inflominmax) {
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Computing INFLOs", relation.size(), LOG) : null;
        HashSetModifiableDBIDs set = DBIDUtil.newHashSet();
        DBIDIter iter = relation.iterDBIDs();
        while (iter.valid()) {
            if (pruned.contains(iter)) {
                inflos.putDouble(iter, 1.0);
                inflominmax.put(1.0);
                LOG.incrementProcessed(prog);
            } else {
                KNNList knn = knnq.getKNNForDBID(iter, this.kplus1);
                if (knn.getKNNDistance() == 0.0) {
                    inflos.putDouble(iter, 1.0);
                    inflominmax.put(1.0);
                    LOG.incrementProcessed(prog);
                } else {
                    set.clear();
                    set.addDBIDs(knn);
                    set.addDBIDs((DBIDs)rNNminuskNNs.get(iter));
                    double sum = 0.0;
                    int c = 0;
                    DBIDMIter niter = set.iter();
                    while (niter.valid()) {
                        if (!DBIDUtil.equal(iter, niter)) {
                            double kdist = knnq.getKNNForDBID(niter, this.kplus1).getKNNDistance();
                            if (kdist <= 0.0) {
                                sum = Double.POSITIVE_INFINITY;
                                ++c;
                                break;
                            }
                            sum += 1.0 / kdist;
                            ++c;
                        }
                        niter.advance();
                    }
                    double inflo = (sum *= knn.getKNNDistance()) == 0.0 ? 1.0 : sum / (double)c;
                    inflos.putDouble(iter, inflo);
                    inflominmax.put(inflo);
                    LOG.incrementProcessed(prog);
                }
            }
            iter.advance();
        }
        LOG.ensureCompleted(prog);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID M_ID = new OptionID("inflo.m", "The pruning threshold");
        public static final OptionID K_ID = new OptionID("inflo.k", "The number of nearest neighbors of an object to be considered for computing its INFLO score.");
        protected double m = 1.0;
        protected int k = 0;

        @Override
        protected void makeOptions(Parameterization config) {
            IntParameter kP;
            super.makeOptions(config);
            DoubleParameter mP = (DoubleParameter)new DoubleParameter(M_ID, 1.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (config.grab(mP)) {
                this.m = mP.doubleValue();
            }
            if (config.grab(kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.k = kP.intValue();
            }
        }

        @Override
        protected INFLO<O> makeInstance() {
            return new INFLO(this.distanceFunction, this.m, this.k);
        }
    }
}

