/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.GaussianKernelDensityFunction;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Title(value="LDF: Outlier Detection with Kernel Density Functions")
@Reference(authors="L. J. Latecki, A. Lazarevic, D. Pokrajac", title="Outlier Detection with Kernel Density Functions", booktitle="Machine Learning and Data Mining in Pattern Recognition", url="https://doi.org/10.1007/978-3-540-73499-4_6", bibkey="DBLP:conf/mldm/LateckiLP07")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.LDF"})
public class LDF<O extends NumberVector>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LDF.class);
    protected int k;
    protected double h = 1.0;
    protected double c = 0.1;
    private KernelDensityFunction kernel;

    public LDF(int k, DistanceFunction<? super O> distance, KernelDensityFunction kernel, double h, double c) {
        super(distance);
        this.k = k + 1;
        this.kernel = kernel;
        this.h = h;
        this.c = c;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("LDF", 3) : null;
        int dim = RelationUtil.dimensionality(relation);
        DBIDs ids = relation.getDBIDs();
        LOG.beginStep(stepprog, 1, "Materializing neighborhoods w.r.t. distance function.");
        KNNQuery<O> knnq = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepprog, 2, "Computing LDEs.");
        WritableDoubleDataStore ldes = DataStoreUtil.makeDoubleStorage(ids, 3);
        FiniteProgress densProgress = LOG.isVerbose() ? new FiniteProgress("Densities", ids.size(), LOG) : null;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            KNNList neighbors = knnq.getKNNForDBID(it, this.k);
            double sum = 0.0;
            int count = 0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal(neighbor, it)) {
                    double nkdist = knnq.getKNNForDBID(neighbor, this.k).getKNNDistance();
                    if (!(nkdist > 0.0) || nkdist == Double.POSITIVE_INFINITY) {
                        sum = Double.POSITIVE_INFINITY;
                        ++count;
                        break;
                    }
                    double v = MathUtil.max(nkdist, neighbor.doubleValue()) / (this.h * nkdist);
                    sum += this.kernel.density(v) / MathUtil.powi(this.h * nkdist, dim);
                    ++count;
                }
                neighbor.advance();
            }
            ldes.putDouble(it, sum / (double)count);
            LOG.incrementProcessed(densProgress);
            it.advance();
        }
        LOG.ensureCompleted(densProgress);
        LOG.beginStep(stepprog, 3, "Computing LDFs.");
        WritableDoubleDataStore ldfs = DataStoreUtil.makeDoubleStorage(ids, 4);
        DoubleMinMax lofminmax = new DoubleMinMax();
        FiniteProgress progressLOFs = LOG.isVerbose() ? new FiniteProgress("Local Density Factors", ids.size(), LOG) : null;
        DBIDIter it2 = ids.iter();
        while (it2.valid()) {
            double lrdp = ldes.doubleValue(it2);
            KNNList neighbors = knnq.getKNNForDBID(it2, this.k);
            double sum = 0.0;
            int count = 0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal(neighbor, it2)) {
                    sum += ldes.doubleValue(neighbor);
                    ++count;
                }
                neighbor.advance();
            }
            double div = lrdp + this.c * (sum /= (double)count);
            double ldf = div == Double.POSITIVE_INFINITY ? (sum < Double.POSITIVE_INFINITY ? 0.0 : 1.0) : (div > 0.0 ? sum / div : 0.0);
            ldfs.putDouble(it2, ldf);
            lofminmax.put(ldf);
            LOG.incrementProcessed(progressLOFs);
            it2.advance();
        }
        LOG.ensureCompleted(progressLOFs);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Local Density Factor", "ldf-outlier", ldfs, ids);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(lofminmax.getMin(), lofminmax.getMax(), 0.0, 1.0 / this.c, 1.0 / (1.0 + this.c));
        OutlierResult result = new OutlierResult(scoreMeta, scoreResult);
        return result;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(new CombinedTypeInformation(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID KERNEL_ID = new OptionID("ldf.kernel", "Kernel to use for LDF.");
        public static final OptionID K_ID = new OptionID("ldf.k", "Number of neighbors to use for LDF.");
        public static final OptionID H_ID = new OptionID("ldf.h", "Kernel bandwidth multiplier for LDF.");
        public static final OptionID C_ID = new OptionID("ldf.c", "Score scaling parameter for LDF.");
        protected int k = 2;
        KernelDensityFunction kernel;
        protected double h = 1.0;
        protected double c = 0.1;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter cP;
            DoubleParameter hP;
            ObjectParameter kernelP;
            super.makeOptions(config);
            IntParameter pK = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(pK)) {
                this.k = (Integer)pK.getValue();
            }
            if (config.grab(kernelP = new ObjectParameter(KERNEL_ID, (Class<?>)KernelDensityFunction.class, GaussianKernelDensityFunction.class))) {
                this.kernel = (KernelDensityFunction)kernelP.instantiateClass(config);
            }
            if (config.grab(hP = new DoubleParameter(H_ID))) {
                this.h = hP.doubleValue();
            }
            if (config.grab(cP = new DoubleParameter(C_ID, 0.1))) {
                this.c = cP.doubleValue();
            }
        }

        @Override
        protected LDF<O> makeInstance() {
            return new LDF(this.k, this.distanceFunction, this.kernel, this.h, this.c);
        }
    }
}

