/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="LDOF: Local Distance-Based Outlier Factor")
@Description(value="Local outlier detection appraoch suitable for scattered data by averaging the kNN distance over all k nearest neighbors")
@Reference(authors="K. Zhang, M. Hutter, H. Jin", title="A New Local Distance-Based Outlier Detection Approach for Scattered Real-World Data", booktitle="Proc. 13th Pacific-Asia Conf. Adv. Knowledge Discovery and Data Mining (PAKDD 2009)", url="https://doi.org/10.1007/978-3-642-01307-2_84", bibkey="DBLP:conf/pakdd/ZhangHJ09")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.LDOF"})
public class LDOF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LDOF.class);
    private static final double LDOF_BASELINE = 0.5;
    protected int k;

    public LDOF(DistanceFunction<? super O> distanceFunction, int k) {
        super(distanceFunction);
        this.k = k + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DistanceQuery<O> distFunc = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnQuery = database.getKNNQuery(distFunc, this.k);
        DoubleMinMax ldofminmax = new DoubleMinMax();
        WritableDoubleDataStore ldofs = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        if (LOG.isVerbose()) {
            LOG.verbose("Computing LDOFs");
        }
        FiniteProgress progressLDOFs = LOG.isVerbose() ? new FiniteProgress("LDOF for objects", relation.size(), LOG) : null;
        Mean dxp = new Mean();
        Mean Dxp = new Mean();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList neighbors = knnQuery.getKNNForDBID(iditer, this.k);
            dxp.reset();
            Dxp.reset();
            DoubleDBIDListIter neighbor1 = neighbors.iter();
            DoubleDBIDListIter neighbor2 = neighbors.iter();
            while (neighbor1.valid()) {
                if (!DBIDUtil.equal(neighbor1, iditer)) {
                    dxp.put(neighbor1.doubleValue());
                    neighbor2.seek(neighbor1.getOffset() + 1);
                    while (neighbor2.valid()) {
                        if (!DBIDUtil.equal(neighbor2, iditer)) {
                            Dxp.put(distFunc.distance((DBIDRef)neighbor1, (DBIDRef)neighbor2));
                        }
                        neighbor2.advance();
                    }
                }
                neighbor1.advance();
            }
            double ldof = dxp.getMean() / Dxp.getMean();
            if (Double.isNaN(ldof) || Double.isInfinite(ldof)) {
                ldof = 1.0;
            }
            ldofs.putDouble(iditer, ldof);
            ldofminmax.put(ldof);
            LOG.incrementProcessed(progressLDOFs);
            iditer.advance();
        }
        LOG.ensureCompleted(progressLDOFs);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("LDOF Outlier Score", "ldof-outlier", ldofs, relation.getDBIDs());
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(ldofminmax.getMin(), ldofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.5);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("ldof.k", "The number of nearest neighbors of an object to be considered for computing its LDOF_SCORE.");
        protected int k;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter kP = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kP)) {
                this.k = (Integer)kP.getValue();
            }
        }

        @Override
        protected LDOF<O> makeInstance() {
            return new LDOF(this.distanceFunction, this.k);
        }
    }
}

