/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Title(value="LOF: Local Outlier Factor")
@Description(value="Algorithm to compute density-based local outlier factors in a database based on the neighborhood size parameter 'k'")
@Reference(authors="Markus M. Breunig, Hans-Peter Kriegel, Raymond Ng, J\u00f6rg Sander", title="LOF: Identifying Density-Based Local Outliers", booktitle="Proc. 2nd ACM SIGMOD Int. Conf. on Management of Data (SIGMOD'00)", url="https://doi.org/10.1145/342009.335388", bibkey="DBLP:conf/sigmod/BreunigKNS00")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.LOF"})
@Priority(value=200)
public class LOF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LOF.class);
    protected int k;

    public LOF(int k, DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
        this.k = k + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("LOF", 3) : null;
        DBIDs ids = relation.getDBIDs();
        LOG.beginStep(stepprog, 1, "Materializing nearest-neighbor sets.");
        KNNQuery<O> knnq = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepprog, 2, "Computing Local Reachability Densities (LRD).");
        WritableDoubleDataStore lrds = DataStoreUtil.makeDoubleStorage(ids, 3);
        this.computeLRDs(knnq, ids, lrds);
        LOG.beginStep(stepprog, 3, "Computing Local Outlier Factors (LOF).");
        WritableDoubleDataStore lofs = DataStoreUtil.makeDoubleStorage(ids, 30);
        DoubleMinMax lofminmax = new DoubleMinMax();
        this.computeLOFScores(knnq, ids, lrds, lofs, lofminmax);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Local Outlier Factor", "lof-outlier", lofs, ids);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(lofminmax.getMin(), lofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    private void computeLRDs(KNNQuery<O> knnq, DBIDs ids, WritableDoubleDataStore lrds) {
        FiniteProgress lrdsProgress = LOG.isVerbose() ? new FiniteProgress("Local Reachability Densities (LRD)", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double lrd = this.computeLRD(knnq, iter);
            lrds.putDouble(iter, lrd);
            LOG.incrementProcessed(lrdsProgress);
            iter.advance();
        }
        LOG.ensureCompleted(lrdsProgress);
    }

    protected double computeLRD(KNNQuery<O> knnq, DBIDIter curr) {
        KNNList neighbors = knnq.getKNNForDBID(curr, this.k);
        double sum = 0.0;
        int count = 0;
        DoubleDBIDListIter neighbor = neighbors.iter();
        while (neighbor.valid()) {
            if (!DBIDUtil.equal(curr, neighbor)) {
                KNNList neighborsNeighbors = knnq.getKNNForDBID(neighbor, this.k);
                sum += MathUtil.max(neighbor.doubleValue(), neighborsNeighbors.getKNNDistance());
                ++count;
            }
            neighbor.advance();
        }
        return sum > 0.0 ? (double)count / sum : Double.POSITIVE_INFINITY;
    }

    private void computeLOFScores(KNNQuery<O> knnq, DBIDs ids, DoubleDataStore lrds, WritableDoubleDataStore lofs, DoubleMinMax lofminmax) {
        FiniteProgress progressLOFs = LOG.isVerbose() ? new FiniteProgress("Local Outlier Factor (LOF) scores", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double lof = this.computeLOFScore(knnq, iter, lrds);
            lofs.putDouble(iter, lof);
            lofminmax.put(lof);
            LOG.incrementProcessed(progressLOFs);
            iter.advance();
        }
        LOG.ensureCompleted(progressLOFs);
    }

    protected double computeLOFScore(KNNQuery<O> knnq, DBIDRef cur, DoubleDataStore lrds) {
        double lrdp = lrds.doubleValue(cur);
        if (Double.isInfinite(lrdp)) {
            return 1.0;
        }
        double sum = 0.0;
        int count = 0;
        KNNList neighbors = knnq.getKNNForDBID(cur, this.k);
        DoubleDBIDListIter neighbor = neighbors.iter();
        while (neighbor.valid()) {
            if (!DBIDUtil.equal(cur, neighbor)) {
                sum += lrds.doubleValue(neighbor);
                ++count;
            }
            neighbor.advance();
        }
        return sum / (lrdp * (double)count);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("lof.k", "The number of nearest neighbors (not including the query point) of an object to be considered for computing its LOF score.");
        protected int k = 2;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter pK = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(pK)) {
                this.k = pK.intValue();
            }
        }

        @Override
        protected LOF<O> makeInstance() {
            return new LOF(this.k, this.distanceFunction);
        }
    }
}

