/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import net.jafama.FastMath;

@Title(value="LoOP: Local Outlier Probabilities")
@Description(value="Variant of the LOF algorithm normalized using statistical values.")
@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="LoOP: Local Outlier Probabilities", booktitle="Proc. 18th Int. Conf. Information and Knowledge Management (CIKM 2009)", url="https://doi.org/10.1145/1645953.1646195", bibkey="DBLP:conf/cikm/KriegelKSZ09")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.LoOP"})
@Priority(value=200)
public class LoOP<O>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(LoOP.class);
    int kreach;
    int kcomp;
    double lambda;
    protected DistanceFunction<? super O> reachabilityDistanceFunction;
    protected DistanceFunction<? super O> comparisonDistanceFunction;

    public LoOP(int kreach, int kcomp, DistanceFunction<? super O> reachabilityDistanceFunction, DistanceFunction<? super O> comparisonDistanceFunction, double lambda) {
        this.kreach = kreach;
        this.kcomp = kcomp;
        this.reachabilityDistanceFunction = reachabilityDistanceFunction;
        this.comparisonDistanceFunction = comparisonDistanceFunction;
        this.lambda = lambda;
    }

    protected Pair<KNNQuery<O>, KNNQuery<O>> getKNNQueries(Database database, Relation<O> relation, StepProgress stepprog) {
        KNNQuery<? super O> knnReach;
        KNNQuery<? super O> knnComp;
        if (this.comparisonDistanceFunction == this.reachabilityDistanceFunction || this.comparisonDistanceFunction.equals(this.reachabilityDistanceFunction)) {
            LOG.beginStep(stepprog, 1, "Materializing neighborhoods with respect to reference neighborhood distance function.");
            knnReach = knnComp = DatabaseUtil.precomputedKNNQuery(database, relation, this.comparisonDistanceFunction, MathUtil.max(this.kcomp, this.kreach) + 1);
        } else {
            LOG.beginStep(stepprog, 1, "Not materializing distance functions, since we request each DBID once only.");
            knnComp = QueryUtil.getKNNQuery(relation, this.comparisonDistanceFunction, this.kreach + 1);
            knnReach = QueryUtil.getKNNQuery(relation, this.reachabilityDistanceFunction, this.kcomp + 1);
        }
        return new Pair<KNNQuery<O>, KNNQuery<O>>(knnComp, knnReach);
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress(5) : null;
        Pair<KNNQuery<O>, KNNQuery<O>> pair = this.getKNNQueries(database, relation, stepprog);
        KNNQuery<O> knnComp = pair.getFirst();
        KNNQuery<O> knnReach = pair.getSecond();
        if (knnComp == null) {
            throw new AbortException("No kNN queries supported by database for comparison distance function.");
        }
        if (knnReach == null) {
            throw new AbortException("No kNN queries supported by database for density estimation distance function.");
        }
        WritableDoubleDataStore pdists = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 30);
        LOG.beginStep(stepprog, 3, "Computing pdists");
        this.computePDists(relation, knnReach, pdists);
        WritableDoubleDataStore plofs = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        LOG.beginStep(stepprog, 4, "Computing PLOF");
        double nplof = this.computePLOFs(relation, knnComp, pdists, plofs);
        DoubleMinMax mm = new DoubleMinMax();
        LOG.beginStep(stepprog, 5, "Computing LoOP scores");
        FiniteProgress progressLOOPs = LOG.isVerbose() ? new FiniteProgress("LoOP for objects", relation.size(), LOG) : null;
        double norm = 1.0 / (nplof * MathUtil.SQRT2);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double loop = NormalDistribution.erf((plofs.doubleValue(iditer) - 1.0) * norm);
            plofs.putDouble(iditer, loop);
            mm.put(loop);
            LOG.incrementProcessed(progressLOOPs);
            iditer.advance();
        }
        LOG.ensureCompleted(progressLOOPs);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Local Outlier Probabilities", "loop-outlier", plofs, relation.getDBIDs());
        ProbabilisticOutlierScore scoreMeta = new ProbabilisticOutlierScore(mm.getMin(), mm.getMax(), 0.0);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    protected void computePDists(Relation<O> relation, KNNQuery<O> knn, WritableDoubleDataStore pdists) {
        FiniteProgress prdsProgress = LOG.isVerbose() ? new FiniteProgress("pdists", relation.size(), LOG) : null;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList neighbors = knn.getKNNForDBID(iditer, this.kreach + 1);
            int ks = 0;
            double ssum = 0.0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid() && ks < this.kreach) {
                if (!DBIDUtil.equal(neighbor, iditer)) {
                    double d = neighbor.doubleValue();
                    ssum += d * d;
                    ++ks;
                }
                neighbor.advance();
            }
            double pdist = ks > 0 ? FastMath.sqrt(ssum / (double)ks) : 0.0;
            pdists.putDouble(iditer, pdist);
            LOG.incrementProcessed(prdsProgress);
            iditer.advance();
        }
        LOG.ensureCompleted(prdsProgress);
    }

    protected double computePLOFs(Relation<O> relation, KNNQuery<O> knn, WritableDoubleDataStore pdists, WritableDoubleDataStore plofs) {
        FiniteProgress progressPLOFs = LOG.isVerbose() ? new FiniteProgress("PLOFs for objects", relation.size(), LOG) : null;
        double nplof = 0.0;
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            KNNList neighbors = knn.getKNNForDBID(iditer, this.kcomp + 1);
            int ks = 0;
            double sum = 0.0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid() && ks < this.kcomp) {
                if (!DBIDUtil.equal(neighbor, iditer)) {
                    sum += pdists.doubleValue(neighbor);
                    ++ks;
                }
                neighbor.advance();
            }
            double plof = MathUtil.max(pdists.doubleValue(iditer) * (double)ks / sum, 1.0);
            if (Double.isNaN(plof) || Double.isInfinite(plof)) {
                plof = 1.0;
            }
            plofs.putDouble(iditer, plof);
            nplof += (plof - 1.0) * (plof - 1.0);
            LOG.incrementProcessed(progressPLOFs);
            iditer.advance();
        }
        LOG.ensureCompleted(progressPLOFs);
        nplof = this.lambda * FastMath.sqrt(nplof / (double)relation.size());
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("nplof normalization factor is " + nplof);
        }
        return nplof > 0.0 ? nplof : 1.0;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        TypeInformation type = this.reachabilityDistanceFunction.equals(this.comparisonDistanceFunction) ? this.reachabilityDistanceFunction.getInputTypeRestriction() : new CombinedTypeInformation(this.reachabilityDistanceFunction.getInputTypeRestriction(), this.comparisonDistanceFunction.getInputTypeRestriction());
        return TypeUtil.array(type);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID REACHABILITY_DISTANCE_FUNCTION_ID = new OptionID("loop.referencedistfunction", "Distance function to determine the density of an object.");
        public static final OptionID COMPARISON_DISTANCE_FUNCTION_ID = new OptionID("loop.comparedistfunction", "Distance function to determine the reference set of an object.");
        public static final OptionID KREACH_ID = new OptionID("loop.kref", "The number of nearest neighbors of an object to be used for the PRD value.");
        public static final OptionID KCOMP_ID = new OptionID("loop.kcomp", "The number of nearest neighbors of an object to be considered for computing its LOOP_SCORE.");
        public static final OptionID LAMBDA_ID = new OptionID("loop.lambda", "The number of standard deviations to consider for density computation.");
        int kreach = 0;
        int kcomp = 0;
        double lambda = 2.0;
        protected DistanceFunction<O> reachabilityDistanceFunction = null;
        protected DistanceFunction<O> comparisonDistanceFunction = null;

        @Override
        protected void makeOptions(Parameterization config) {
            DoubleParameter lambdaP;
            IntParameter kreachP;
            ObjectParameter compDistP;
            super.makeOptions(config);
            IntParameter kcompP = (IntParameter)new IntParameter(KCOMP_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(kcompP)) {
                this.kcomp = kcompP.intValue();
            }
            if (config.grab(compDistP = new ObjectParameter(COMPARISON_DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class))) {
                this.comparisonDistanceFunction = (DistanceFunction)compDistP.instantiateClass(config);
            }
            this.kreach = config.grab(kreachP = (IntParameter)((IntParameter)new IntParameter(KREACH_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT)).setOptional(true)) ? kreachP.intValue() : this.kcomp;
            ObjectParameter reachDistP = new ObjectParameter(REACHABILITY_DISTANCE_FUNCTION_ID, DistanceFunction.class, true);
            if (config.grab(reachDistP)) {
                this.reachabilityDistanceFunction = (DistanceFunction)reachDistP.instantiateClass(config);
            }
            if (config.grab(lambdaP = (DoubleParameter)new DoubleParameter(LAMBDA_ID, 2.0).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.lambda = lambdaP.doubleValue();
            }
        }

        @Override
        protected LoOP<O> makeInstance() {
            DistanceFunction<O> realreach = this.reachabilityDistanceFunction != null ? this.reachabilityDistanceFunction : this.comparisonDistanceFunction;
            return new LoOP<O>(this.kreach, this.kcomp, realreach, this.comparisonDistanceFunction, this.lambda);
        }
    }
}

