/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.FlexibleLOF;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.PreprocessorKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.KNNChangeEvent;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.KNNListener;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNAndRKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.OnlineLOF"})
public class OnlineLOF<O>
extends FlexibleLOF<O> {
    private static final Logging LOG = Logging.getLogger(OnlineLOF.class);

    public OnlineLOF(int krefer, int kreach, DistanceFunction<? super O> neighborhoodDistanceFunction, DistanceFunction<? super O> reachabilityDistanceFunction) {
        super(krefer, kreach, neighborhoodDistanceFunction, reachabilityDistanceFunction);
    }

    @Override
    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("OnlineLOF", 3) : null;
        Pair<Pair<KNNQuery<O>, KNNQuery<O>>, Pair<RKNNQuery<O>, RKNNQuery<O>>> queries = this.getKNNAndRkNNQueries(database, relation, stepprog);
        KNNQuery<O> kNNRefer = queries.getFirst().getFirst();
        KNNQuery<O> kNNReach = queries.getFirst().getSecond();
        RKNNQuery<O> rkNNRefer = queries.getSecond().getFirst();
        RKNNQuery<O> rkNNReach = queries.getSecond().getSecond();
        FlexibleLOF.LOFResult<O> lofResult = super.doRunInTime(relation.getDBIDs(), kNNRefer, kNNReach, stepprog);
        lofResult.setRkNNRefer(rkNNRefer);
        lofResult.setRkNNReach(rkNNReach);
        LOFKNNListener l = new LOFKNNListener(lofResult);
        ((MaterializeKNNPreprocessor)((PreprocessorKNNQuery)lofResult.getKNNRefer()).getPreprocessor()).addKNNListener(l);
        ((MaterializeKNNPreprocessor)((PreprocessorKNNQuery)lofResult.getKNNReach()).getPreprocessor()).addKNNListener(l);
        return lofResult.getResult();
    }

    private Pair<Pair<KNNQuery<O>, KNNQuery<O>>, Pair<RKNNQuery<O>, RKNNQuery<O>>> getKNNAndRkNNQueries(Database database, Relation<O> relation, StepProgress stepprog) {
        DistanceQuery<O> drefQ = database.getDistanceQuery(relation, this.referenceDistanceFunction, new Object[0]);
        KNNQuery<O> kNNRefer = database.getKNNQuery(drefQ, this.krefer, "heavy", "optimized", "no-cache");
        RKNNQuery<O> rkNNRefer = database.getRKNNQuery(drefQ, "heavy", "optimized", "no-cache");
        if (kNNRefer == null || rkNNRefer == null) {
            if (stepprog != null) {
                stepprog.beginStep(1, "Materializing neighborhood w.r.t. reference neighborhood distance function.", LOG);
            }
            MaterializeKNNAndRKNNPreprocessor<O> preproc = new MaterializeKNNAndRKNNPreprocessor<O>(relation, this.referenceDistanceFunction, this.krefer);
            kNNRefer = preproc.getKNNQuery(drefQ, this.krefer, "heavy");
            rkNNRefer = preproc.getRKNNQuery(drefQ, this.krefer, "heavy");
            database.getHierarchy().add(relation, preproc);
        } else if (stepprog != null) {
            stepprog.beginStep(1, "Optimized neighborhood w.r.t. reference neighborhood distance function provided by database.", LOG);
        }
        DistanceQuery<O> dreachQ = database.getDistanceQuery(relation, this.reachabilityDistanceFunction, new Object[0]);
        KNNQuery<O> kNNReach = database.getKNNQuery(dreachQ, this.kreach, "heavy", "optimized", "no-cache");
        RKNNQuery<O> rkNNReach = database.getRKNNQuery(dreachQ, "heavy", "optimized", "no-cache");
        if (kNNReach == null || rkNNReach == null) {
            if (stepprog != null) {
                stepprog.beginStep(2, "Materializing neighborhood w.r.t. reachability distance function.", LOG);
            }
            ListParameterization config = new ListParameterization();
            config.addParameter(AbstractMaterializeKNNPreprocessor.Factory.DISTANCE_FUNCTION_ID, (Object)this.reachabilityDistanceFunction);
            config.addParameter(AbstractMaterializeKNNPreprocessor.Factory.K_ID, (Object)this.kreach);
            MaterializeKNNAndRKNNPreprocessor<O> preproc = new MaterializeKNNAndRKNNPreprocessor<O>(relation, this.reachabilityDistanceFunction, this.kreach);
            kNNReach = preproc.getKNNQuery(dreachQ, this.kreach, "heavy");
            rkNNReach = preproc.getRKNNQuery(dreachQ, this.kreach, "heavy");
            database.getHierarchy().add(relation, preproc);
        }
        Pair<KNNQuery<O>, KNNQuery<O>> kNNPair = new Pair<KNNQuery<O>, KNNQuery<O>>(kNNRefer, kNNReach);
        Pair<RKNNQuery<O>, RKNNQuery<O>> rkNNPair = new Pair<RKNNQuery<O>, RKNNQuery<O>>(rkNNRefer, rkNNReach);
        return new Pair<Pair<KNNQuery<O>, KNNQuery<O>>, Pair<RKNNQuery<O>, RKNNQuery<O>>>(kNNPair, rkNNPair);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends FlexibleLOF.Parameterizer<O> {
        @Override
        protected OnlineLOF<O> makeInstance() {
            return new OnlineLOF(this.kreach, this.krefer, this.distanceFunction, this.reachabilityDistanceFunction);
        }
    }

    private class LOFKNNListener
    implements KNNListener {
        private KNNChangeEvent firstEventReceived;
        private FlexibleLOF.LOFResult<O> lofResult;

        public LOFKNNListener(FlexibleLOF.LOFResult<O> lofResult) {
            this.lofResult = lofResult;
        }

        @Override
        public void kNNsChanged(KNNChangeEvent e) {
            AbstractMaterializeKNNPreprocessor p1 = ((PreprocessorKNNQuery)this.lofResult.getKNNRefer()).getPreprocessor();
            AbstractMaterializeKNNPreprocessor p2 = ((PreprocessorKNNQuery)this.lofResult.getKNNReach()).getPreprocessor();
            if (this.firstEventReceived == null) {
                if (e.getSource().equals(p1) && e.getSource().equals(p2)) {
                    this.kNNsChanged(e, e);
                } else {
                    this.firstEventReceived = e;
                }
            } else if (e.getSource().equals(p1) && this.firstEventReceived.getSource().equals(p2)) {
                this.kNNsChanged(e, this.firstEventReceived);
                this.firstEventReceived = null;
            } else if (e.getSource().equals(p2) && this.firstEventReceived.getSource().equals(p1)) {
                this.kNNsChanged(this.firstEventReceived, e);
                this.firstEventReceived = null;
            } else {
                throw new UnsupportedOperationException("Event sources do not fit!");
            }
        }

        private void kNNsChanged(KNNChangeEvent e1, KNNChangeEvent e2) {
            if (!e1.getType().equals((Object)e2.getType())) {
                throw new UnsupportedOperationException("Event types do not fit: " + (Object)((Object)e1.getType()) + " != " + (Object)((Object)e2.getType()));
            }
            if (!e1.getObjects().equals(e2.getObjects())) {
                throw new UnsupportedOperationException("Objects do not fit: " + e1.getObjects() + " != " + e2.getObjects());
            }
            if (e1.getType().equals((Object)KNNChangeEvent.Type.DELETE)) {
                this.kNNsRemoved(e1.getObjects(), e1.getUpdates(), e2.getUpdates(), this.lofResult);
            } else if (e1.getType().equals((Object)KNNChangeEvent.Type.INSERT)) {
                this.kNNsInserted(e1.getObjects(), e1.getUpdates(), e2.getUpdates(), this.lofResult);
            } else {
                throw new UnsupportedOperationException("Unsupported event type: " + (Object)((Object)e1.getType()));
            }
        }

        private void kNNsInserted(DBIDs insertions, DBIDs updates1, DBIDs updates2, FlexibleLOF.LOFResult<O> lofResult) {
            StepProgress stepprog;
            StepProgress stepProgress = stepprog = LOG.isVerbose() ? new StepProgress(3) : null;
            if (stepprog != null) {
                stepprog.beginStep(1, "Recompute LRDs.", LOG);
            }
            ArrayDBIDs lrd_ids = DBIDUtil.ensureArray(DBIDUtil.union(insertions, updates2));
            List<DoubleDBIDList> reachDistRKNNs = lofResult.getRkNNReach().getRKNNForBulkDBIDs(lrd_ids, OnlineLOF.this.kreach);
            ArrayModifiableDBIDs affected_lrd_id_candidates = this.mergeIDs(reachDistRKNNs, lrd_ids);
            ArrayModifiableDBIDs affected_lrd_ids = DBIDUtil.newArray(affected_lrd_id_candidates.size());
            WritableDoubleDataStore new_lrds = DataStoreUtil.makeDoubleStorage(affected_lrd_id_candidates, 3);
            OnlineLOF.this.computeLRDs(lofResult.getKNNReach(), affected_lrd_id_candidates, new_lrds);
            DBIDArrayIter iter = affected_lrd_id_candidates.iter();
            while (iter.valid()) {
                double new_lrd = new_lrds.doubleValue(iter);
                double old_lrd = lofResult.getLrds().doubleValue(iter);
                if (Double.isNaN(old_lrd) || old_lrd != new_lrd) {
                    lofResult.getLrds().putDouble(iter, new_lrd);
                    affected_lrd_ids.add(iter);
                }
                iter.advance();
            }
            if (stepprog != null) {
                stepprog.beginStep(2, "Recompute LOFS.", LOG);
            }
            List<DoubleDBIDList> primDistRKNNs = lofResult.getRkNNRefer().getRKNNForBulkDBIDs(affected_lrd_ids, OnlineLOF.this.krefer);
            ArrayModifiableDBIDs affected_lof_ids = this.mergeIDs(primDistRKNNs, affected_lrd_ids, insertions, updates1);
            this.recomputeLOFs(affected_lof_ids, lofResult);
            if (stepprog != null) {
                stepprog.beginStep(3, "Inform listeners.", LOG);
            }
            lofResult.getResult().getHierarchy().resultChanged(lofResult.getResult());
            LOG.setCompleted(stepprog);
        }

        private void kNNsRemoved(DBIDs deletions, DBIDs updates1, DBIDs updates2, FlexibleLOF.LOFResult<O> lofResult) {
            StepProgress stepprog;
            StepProgress stepProgress = stepprog = LOG.isVerbose() ? new StepProgress(4) : null;
            if (stepprog != null) {
                stepprog.beginStep(1, "Delete old LRDs and LOFs.", LOG);
            }
            DBIDIter iter = deletions.iter();
            while (iter.valid()) {
                lofResult.getLrds().delete(iter);
                lofResult.getLofs().delete(iter);
                iter.advance();
            }
            if (stepprog != null) {
                stepprog.beginStep(2, "Recompute LRDs.", LOG);
            }
            ArrayDBIDs lrd_ids = DBIDUtil.ensureArray(updates2);
            List<DoubleDBIDList> reachDistRKNNs = lofResult.getRkNNReach().getRKNNForBulkDBIDs(lrd_ids, OnlineLOF.this.kreach);
            ArrayModifiableDBIDs affected_lrd_id_candidates = this.mergeIDs(reachDistRKNNs, lrd_ids);
            ArrayModifiableDBIDs affected_lrd_ids = DBIDUtil.newArray(affected_lrd_id_candidates.size());
            WritableDoubleDataStore new_lrds = DataStoreUtil.makeDoubleStorage(affected_lrd_id_candidates, 3);
            OnlineLOF.this.computeLRDs(lofResult.getKNNReach(), affected_lrd_id_candidates, new_lrds);
            DBIDArrayIter iter2 = affected_lrd_id_candidates.iter();
            while (iter2.valid()) {
                double new_lrd = new_lrds.doubleValue(iter2);
                double old_lrd = lofResult.getLrds().doubleValue(iter2);
                if (old_lrd != new_lrd) {
                    lofResult.getLrds().putDouble(iter2, new_lrd);
                    affected_lrd_ids.add(iter2);
                }
                iter2.advance();
            }
            if (stepprog != null) {
                stepprog.beginStep(3, "Recompute LOFS.", LOG);
            }
            List<DoubleDBIDList> primDistRKNNs = lofResult.getRkNNRefer().getRKNNForBulkDBIDs(affected_lrd_ids, OnlineLOF.this.krefer);
            ArrayModifiableDBIDs affected_lof_ids = this.mergeIDs(primDistRKNNs, affected_lrd_ids, updates1);
            this.recomputeLOFs(affected_lof_ids, lofResult);
            if (stepprog != null) {
                stepprog.beginStep(4, "Inform listeners.", LOG);
            }
            lofResult.getResult().getHierarchy().resultChanged(lofResult.getResult());
            LOG.setCompleted(stepprog);
        }

        private ArrayModifiableDBIDs mergeIDs(List<? extends DoubleDBIDList> queryResults, DBIDs ... ids) {
            HashSetModifiableDBIDs result = DBIDUtil.newHashSet();
            for (DBIDs dbids : ids) {
                result.addDBIDs(dbids);
            }
            for (DoubleDBIDList doubleDBIDList : queryResults) {
                result.addDBIDs(doubleDBIDList);
            }
            return DBIDUtil.newArray(result);
        }

        private void recomputeLOFs(DBIDs ids, FlexibleLOF.LOFResult<O> lofResult) {
            WritableDoubleDataStore new_lofs = DataStoreUtil.makeDoubleStorage(ids, 3);
            DoubleMinMax new_lofminmax = new DoubleMinMax();
            OnlineLOF.this.computeLOFs(lofResult.getKNNRefer(), ids, lofResult.getLrds(), new_lofs, new_lofminmax);
            DBIDIter iter = ids.iter();
            while (iter.valid()) {
                lofResult.getLofs().putDouble(iter, new_lofs.doubleValue(iter));
                iter.advance();
            }
            if (new_lofminmax.isValid()) {
                BasicOutlierScoreMeta scoreMeta;
                if (lofResult.getResult().getOutlierMeta().getActualMaximum() < new_lofminmax.getMax()) {
                    scoreMeta = (BasicOutlierScoreMeta)lofResult.getResult().getOutlierMeta();
                    scoreMeta.setActualMaximum(new_lofminmax.getMax());
                }
                if (lofResult.getResult().getOutlierMeta().getActualMinimum() > new_lofminmax.getMin()) {
                    scoreMeta = (BasicOutlierScoreMeta)lofResult.getResult().getOutlierMeta();
                    scoreMeta.setActualMinimum(new_lofminmax.getMin());
                }
            }
        }
    }
}

