/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LOF;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.EpanechnikovKernelDensityFunction;
import de.lmu.ifi.dbs.elki.math.statistics.kernelfunctions.KernelDensityFunction;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.SimpleKernelDensityLOF"})
public class SimpleKernelDensityLOF<O extends NumberVector>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimpleKernelDensityLOF.class);
    protected int k;
    private KernelDensityFunction kernel;

    public SimpleKernelDensityLOF(int k, DistanceFunction<? super O> distance, KernelDensityFunction kernel) {
        super(distance);
        this.k = k + 1;
        this.kernel = kernel;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("KernelDensityLOF", 3) : null;
        int dim = RelationUtil.dimensionality(relation);
        DBIDs ids = relation.getDBIDs();
        LOG.beginStep(stepprog, 1, "Materializing neighborhoods w.r.t. distance function.");
        KNNQuery<O> knnq = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepprog, 2, "Computing densities.");
        WritableDoubleDataStore dens = DataStoreUtil.makeDoubleStorage(ids, 3);
        FiniteProgress densProgress = LOG.isVerbose() ? new FiniteProgress("Densities", ids.size(), LOG) : null;
        DBIDIter it = ids.iter();
        while (it.valid()) {
            KNNList neighbors = knnq.getKNNForDBID(it, this.k);
            int count = 0;
            double sum = 0.0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal(neighbor, it)) {
                    double max = knnq.getKNNForDBID(neighbor, this.k).getKNNDistance();
                    if (max == 0.0) {
                        sum = Double.POSITIVE_INFINITY;
                        break;
                    }
                    double v = neighbor.doubleValue() / max;
                    sum += this.kernel.density(v) / MathUtil.powi(max, dim);
                    ++count;
                }
                neighbor.advance();
            }
            double density = count > 0 ? sum / (double)count : 0.0;
            dens.putDouble(it, density);
            LOG.incrementProcessed(densProgress);
            it.advance();
        }
        LOG.ensureCompleted(densProgress);
        LOG.beginStep(stepprog, 3, "Computing KLOFs.");
        WritableDoubleDataStore lofs = DataStoreUtil.makeDoubleStorage(ids, 4);
        DoubleMinMax lofminmax = new DoubleMinMax();
        FiniteProgress progressLOFs = LOG.isVerbose() ? new FiniteProgress("KLOF_SCORE for objects", ids.size(), LOG) : null;
        DBIDIter it2 = ids.iter();
        while (it2.valid()) {
            double lof;
            double lrdp = dens.doubleValue(it2);
            if (lrdp > 0.0) {
                KNNList neighbors = knnq.getKNNForDBID(it2, this.k);
                double sum = 0.0;
                int count = 0;
                DoubleDBIDListIter neighbor = neighbors.iter();
                while (neighbor.valid()) {
                    if (!DBIDUtil.equal(neighbor, it2)) {
                        sum += dens.doubleValue(neighbor);
                        ++count;
                    }
                    neighbor.advance();
                }
                lof = lrdp == Double.POSITIVE_INFINITY ? (sum == Double.POSITIVE_INFINITY ? 1.0 : 0.0) : sum / ((double)count * lrdp);
            } else {
                lof = 1.0;
            }
            lofs.putDouble(it2, lof);
            lofminmax.put(lof);
            LOG.incrementProcessed(progressLOFs);
            it2.advance();
        }
        LOG.ensureCompleted(progressLOFs);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Kernel Density Local Outlier Factor", "kernel-density-slof-outlier", lofs, ids);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(lofminmax.getMin(), lofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult result = new OutlierResult(scoreMeta, scoreResult);
        return result;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(new CombinedTypeInformation(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID KERNEL_ID = new OptionID("kernellof.kernel", "Kernel to use for kernel density LOF.");
        protected int k;
        KernelDensityFunction kernel;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter kernelP;
            super.makeOptions(config);
            IntParameter pK = (IntParameter)new IntParameter(LOF.Parameterizer.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(pK)) {
                this.k = (Integer)pK.getValue();
            }
            if (config.grab(kernelP = new ObjectParameter(KERNEL_ID, (Class<?>)KernelDensityFunction.class, EpanechnikovKernelDensityFunction.class))) {
                this.kernel = (KernelDensityFunction)kernelP.instantiateClass(config);
            }
        }

        @Override
        protected SimpleKernelDensityLOF<O> makeInstance() {
            return new SimpleKernelDensityLOF(this.k, this.distanceFunction, this.kernel);
        }
    }
}

