/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LOF;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.QuotientOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Local Outlier Detection Reconsidered: a Generalized View on Locality with Applications to Spatial, Video, and Network Outlier Detection", booktitle="Data Mining and Knowledge Discovery 28(1)", url="https://doi.org/10.1007/s10618-012-0300-z", bibkey="DBLP:journals/datamine/SchubertZK14")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.SimpleLOF"})
public class SimplifiedLOF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimplifiedLOF.class);
    protected int k;

    public SimplifiedLOF(int k, DistanceFunction<? super O> distance) {
        super(distance);
        this.k = k + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("Simplified LOF", 3) : null;
        DBIDs ids = relation.getDBIDs();
        LOG.beginStep(stepprog, 1, "Materializing neighborhoods w.r.t. distance function.");
        KNNQuery<O> knnq = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepprog, 2, "Computing densities.");
        WritableDoubleDataStore dens = DataStoreUtil.makeDoubleStorage(ids, 3);
        this.computeSimplifiedLRDs(ids, knnq, dens);
        LOG.beginStep(stepprog, 3, "Computing SLOFs.");
        WritableDoubleDataStore lofs = DataStoreUtil.makeDoubleStorage(ids, 4);
        DoubleMinMax lofminmax = new DoubleMinMax();
        this.computeSimplifiedLOFs(ids, knnq, dens, lofs, lofminmax);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Simplified Local Outlier Factor", "simplified-lof-outlier", lofs, ids);
        QuotientOutlierScoreMeta scoreMeta = new QuotientOutlierScoreMeta(lofminmax.getMin(), lofminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        OutlierResult result = new OutlierResult(scoreMeta, scoreResult);
        return result;
    }

    private void computeSimplifiedLRDs(DBIDs ids, KNNQuery<O> knnq, WritableDoubleDataStore lrds) {
        FiniteProgress lrdsProgress = LOG.isVerbose() ? new FiniteProgress("Densities", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList neighbors = knnq.getKNNForDBID(iter, this.k);
            double sum = 0.0;
            int count = 0;
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal(neighbor, iter)) {
                    sum += neighbor.doubleValue();
                    ++count;
                }
                neighbor.advance();
            }
            double lrd = sum > 0.0 ? (double)count / sum : Double.POSITIVE_INFINITY;
            lrds.putDouble(iter, lrd);
            LOG.incrementProcessed(lrdsProgress);
            iter.advance();
        }
        LOG.ensureCompleted(lrdsProgress);
    }

    private void computeSimplifiedLOFs(DBIDs ids, KNNQuery<O> knnq, WritableDoubleDataStore slrds, WritableDoubleDataStore lofs, DoubleMinMax lofminmax) {
        FiniteProgress progressLOFs = LOG.isVerbose() ? new FiniteProgress("Simplified LOF scores", ids.size(), LOG) : null;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double lof;
            double lrdp = slrds.doubleValue(iter);
            KNNList neighbors = knnq.getKNNForDBID(iter, this.k);
            if (!Double.isInfinite(lrdp)) {
                double sum = 0.0;
                int count = 0;
                DoubleDBIDListIter neighbor = neighbors.iter();
                while (neighbor.valid()) {
                    if (!DBIDUtil.equal(neighbor, iter)) {
                        double val = slrds.doubleValue(neighbor);
                        sum += val;
                        ++count;
                        if (Double.isInfinite(val)) break;
                    }
                    neighbor.advance();
                }
                lof = sum / (lrdp * (double)count);
            } else {
                lof = 1.0;
            }
            lofs.putDouble(iter, lof);
            lofminmax.put(lof);
            LOG.incrementProcessed(progressLOFs);
            iter.advance();
        }
        LOG.ensureCompleted(progressLOFs);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        protected int k = 2;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter pK = (IntParameter)new IntParameter(LOF.Parameterizer.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(pK)) {
                this.k = (Integer)pK.getValue();
            }
        }

        @Override
        protected SimplifiedLOF<O> makeInstance() {
            return new SimplifiedLOF(this.k, this.distanceFunction);
        }
    }
}

