/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.DatabaseUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.StepProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import net.jafama.FastMath;

@Reference(authors="T. Hu, S. Y. Sung", title="Detecting pattern-based outliers", booktitle="Pattern Recognition Letters 24(16)", url="https://doi.org/10.1016/S0167-8655(03)00165-X", bibkey="DBLP:journals/prl/HuS03")
public class VarianceOfVolume<O extends SpatialComparable>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(VarianceOfVolume.class);
    protected int k;

    public VarianceOfVolume(int k, DistanceFunction<? super O> distanceFunction) {
        super(distanceFunction);
        this.k = k + 1;
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        StepProgress stepprog = LOG.isVerbose() ? new StepProgress("VOV", 3) : null;
        DBIDs ids = relation.getDBIDs();
        int dim = RelationUtil.dimensionality(relation);
        LOG.beginStep(stepprog, 1, "Materializing nearest-neighbor sets.");
        KNNQuery<O> knnq = DatabaseUtil.precomputedKNNQuery(database, relation, this.getDistanceFunction(), this.k);
        LOG.beginStep(stepprog, 2, "Computing Volumes.");
        WritableDoubleDataStore vols = DataStoreUtil.makeDoubleStorage(ids, 3);
        this.computeVolumes(knnq, dim, ids, vols);
        LOG.beginStep(stepprog, 3, "Computing Variance of Volumes (VOV).");
        WritableDoubleDataStore vovs = DataStoreUtil.makeDoubleStorage(ids, 30);
        DoubleMinMax vovminmax = new DoubleMinMax();
        this.computeVOVs(knnq, ids, vols, vovs, vovminmax);
        LOG.setCompleted(stepprog);
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("Variance of Volume", "vov-outlier", vovs, ids);
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(vovminmax.getMin(), vovminmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    private void computeVolumes(KNNQuery<O> knnq, int dim, DBIDs ids, WritableDoubleDataStore vols) {
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Volume", ids.size(), LOG) : null;
        double scaleconst = MathUtil.SQRTPI * FastMath.pow(GammaDistribution.gamma(1.0 + (double)dim * 0.5), -1.0 / (double)dim);
        boolean warned = false;
        double sum = 0.0;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            double vol;
            double dk = knnq.getKNNForDBID(iter, this.k).getKNNDistance();
            double d = vol = dk > 0.0 ? MathUtil.powi(dk * scaleconst, dim) : 0.0;
            if (vol == Double.POSITIVE_INFINITY && !warned) {
                LOG.warning("Variance of Volumes has hit double precision limits, results are not reliable.");
                warned = true;
            }
            vols.putDouble(iter, vol);
            sum += vol;
            LOG.incrementProcessed(prog);
            iter.advance();
        }
        double scaling = (double)ids.size() / sum;
        DBIDIter iter2 = ids.iter();
        while (iter2.valid()) {
            vols.putDouble(iter2, vols.doubleValue(iter2) * scaling);
            iter2.advance();
        }
        LOG.ensureCompleted(prog);
    }

    private void computeVOVs(KNNQuery<O> knnq, DBIDs ids, DoubleDataStore vols, WritableDoubleDataStore vovs, DoubleMinMax vovminmax) {
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Variance of Volume", ids.size(), LOG) : null;
        boolean warned = false;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            KNNList knns = knnq.getKNNForDBID(iter, this.k);
            DoubleDBIDListIter it = knns.iter();
            double vbar = 0.0;
            while (it.valid()) {
                vbar += vols.doubleValue(it);
                it.advance();
            }
            vbar /= (double)knns.size();
            double vov = 0.0;
            it.seek(0);
            while (it.valid()) {
                double v = vols.doubleValue(it) - vbar;
                vov += v * v;
                it.advance();
            }
            if (!(vov < Double.POSITIVE_INFINITY) && !warned) {
                LOG.warning("Variance of Volumes has hit double precision limits, results are not reliable.");
                warned = true;
            }
            vov = vov < Double.POSITIVE_INFINITY ? vov / (double)(knns.size() - 1) : Double.POSITIVE_INFINITY;
            vovs.putDouble(iter, vov);
            vovminmax.put(vov);
            LOG.incrementProcessed(prog);
            iter.advance();
        }
        LOG.ensureCompleted(prog);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(new CombinedTypeInformation(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.SPATIAL_OBJECT));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O extends SpatialComparable>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID K_ID = new OptionID("vov.k", "The number of nearest neighbors (not including the query point) of an object to be considered for computing its VOV score.");
        protected int k = 2;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter pK = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(pK)) {
                this.k = pK.intValue();
            }
        }

        @Override
        protected VarianceOfVolume<O> makeInstance() {
            return new VarianceOfVolume(this.k, this.distanceFunction);
        }
    }
}

