/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel;

import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.AbstractDoubleProcessor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedDouble;

public class LOFProcessor
extends AbstractDoubleProcessor {
    private DataStore<? extends KNNList> knns;
    private DoubleDataStore lrds;
    private boolean noself;

    public LOFProcessor(DataStore<? extends KNNList> knns, DoubleDataStore lrds, boolean noself) {
        this.knns = knns;
        this.lrds = lrds;
        this.noself = noself;
    }

    @Override
    public Instance instantiate(Executor master) {
        return new Instance(master.getInstance(this.output));
    }

    private class Instance
    extends AbstractDoubleProcessor.Instance {
        protected Instance(SharedDouble.Instance output) {
            super(output);
        }

        @Override
        public void map(DBIDRef id) {
            double lrdp = LOFProcessor.this.lrds.doubleValue(id);
            if (Double.isInfinite(lrdp)) {
                this.output.set(1.0);
                return;
            }
            KNNList knn = (KNNList)LOFProcessor.this.knns.get(id);
            double avlrd = 0.0;
            int cnt = 0;
            DoubleDBIDListIter n = knn.iter();
            while (n.valid()) {
                if (!LOFProcessor.this.noself || !DBIDUtil.equal(n, id)) {
                    ++cnt;
                    if (Double.isInfinite(avlrd += LOFProcessor.this.lrds.doubleValue(n))) break;
                }
                n.advance();
            }
            avlrd = cnt > 0 ? avlrd / (double)cnt : 0.0;
            this.output.set(avlrd / lrdp);
        }
    }
}

