/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel;

import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.AbstractDoubleProcessor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedDouble;

public class LRDProcessor
extends AbstractDoubleProcessor {
    private DataStore<? extends KNNList> knns;
    private DoubleDataStore kdists;

    public LRDProcessor(DataStore<? extends KNNList> knns, DoubleDataStore kdists) {
        this.knns = knns;
        this.kdists = kdists;
    }

    @Override
    public Instance instantiate(Executor master) {
        return new Instance(master.getInstance(this.output));
    }

    private class Instance
    extends AbstractDoubleProcessor.Instance {
        protected Instance(SharedDouble.Instance output) {
            super(output);
        }

        @Override
        public void map(DBIDRef id) {
            KNNList knn = (KNNList)LRDProcessor.this.knns.get(id);
            double lrd = 0.0;
            int size = 0;
            DoubleDBIDListIter n = knn.iter();
            while (n.valid()) {
                if (!DBIDUtil.equal(n, id)) {
                    lrd += MathUtil.max(LRDProcessor.this.kdists.doubleValue(n), n.doubleValue());
                    ++size;
                }
                n.advance();
            }
            this.output.set(lrd > 0.0 ? (double)size / lrd : Double.POSITIVE_INFINITY);
        }
    }
}

