/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LOF;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel.LOFProcessor;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel.LRDProcessor;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.parallel.ParallelExecutor;
import de.lmu.ifi.dbs.elki.parallel.processor.DoubleMinMaxProcessor;
import de.lmu.ifi.dbs.elki.parallel.processor.KDistanceProcessor;
import de.lmu.ifi.dbs.elki.parallel.processor.KNNProcessor;
import de.lmu.ifi.dbs.elki.parallel.processor.WriteDataStoreProcessor;
import de.lmu.ifi.dbs.elki.parallel.processor.WriteDoubleDataStoreProcessor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedDouble;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedObject;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Reference(authors="Erich Schubert, Arthur Zimek, Hans-Peter Kriegel", title="Local Outlier Detection Reconsidered: a Generalized View on Locality with Applications to Spatial, Video, and Network Outlier Detection", booktitle="Data Mining and Knowledge Discovery 28(1)", url="https://doi.org/10.1007/s10618-012-0300-z", bibkey="DBLP:journals/datamine/SchubertZK14")
public class ParallelLOF<O>
extends AbstractDistanceBasedAlgorithm<O, OutlierResult>
implements OutlierAlgorithm {
    private int k;
    private static final Logging LOG = Logging.getLogger(ParallelLOF.class);

    public ParallelLOF(DistanceFunction<? super O> distanceFunction, int k) {
        super(distanceFunction);
        this.k = k;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    public OutlierResult run(Database database, Relation<O> relation) {
        DBIDs ids = relation.getDBIDs();
        DistanceQuery<O> distq = database.getDistanceQuery(relation, this.getDistanceFunction(), new Object[0]);
        KNNQuery<O> knnq = database.getKNNQuery(distq, this.k + 1);
        WritableDoubleDataStore kdists = DataStoreUtil.makeDoubleStorage(ids, 30);
        WritableDataStore<KNNList> knns = DataStoreUtil.makeStorage(ids, 30, KNNList.class);
        KNNProcessor<O> knnm = new KNNProcessor<O>(this.k + 1, knnq);
        SharedObject<KNNList> knnv = new SharedObject<KNNList>();
        WriteDataStoreProcessor<KNNList> storek = new WriteDataStoreProcessor<KNNList>(knns);
        knnm.connectKNNOutput(knnv);
        storek.connectInput(knnv);
        KDistanceProcessor kdistm = new KDistanceProcessor(this.k + 1);
        SharedDouble kdistv = new SharedDouble();
        WriteDoubleDataStoreProcessor storem = new WriteDoubleDataStoreProcessor(kdists);
        kdistm.connectKNNInput(knnv);
        kdistm.connectOutput(kdistv);
        storem.connectInput(kdistv);
        ParallelExecutor.run(ids, knnm, storek, kdistm, storem);
        WritableDoubleDataStore lrds = DataStoreUtil.makeDoubleStorage(ids, 30);
        LRDProcessor lrdm = new LRDProcessor(knns, kdists);
        SharedDouble lrdv = new SharedDouble();
        WriteDoubleDataStoreProcessor storelrd = new WriteDoubleDataStoreProcessor(lrds);
        lrdm.connectOutput(lrdv);
        storelrd.connectInput(lrdv);
        ParallelExecutor.run(ids, lrdm, storelrd);
        kdists.destroy();
        kdists = null;
        WritableDoubleDataStore lofs = DataStoreUtil.makeDoubleStorage(ids, 30);
        LOFProcessor lofm = new LOFProcessor(knns, lrds, true);
        SharedDouble lofv = new SharedDouble();
        DoubleMinMaxProcessor mmm = new DoubleMinMaxProcessor();
        WriteDoubleDataStoreProcessor storelof = new WriteDoubleDataStoreProcessor(lofs);
        lofm.connectOutput(lofv);
        mmm.connectInput(lofv);
        storelof.connectInput(lofv);
        ParallelExecutor.run(ids, lofm, storelof, mmm);
        DoubleMinMax minmax = mmm.getMinMax();
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Local Outlier Factor", "lof-outlier", lofs, ids);
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 1.0);
        return new OutlierResult(meta, scoreres);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        int k;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            IntParameter kP = new IntParameter(LOF.Parameterizer.K_ID);
            if (config.grab(kP)) {
                this.k = kP.intValue();
            }
        }

        @Override
        protected ParallelLOF<O> makeInstance() {
            return new ParallelLOF(this.distanceFunction, this.k);
        }
    }
}

