/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.lof.parallel;

import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.parallel.Executor;
import de.lmu.ifi.dbs.elki.parallel.processor.AbstractDoubleProcessor;
import de.lmu.ifi.dbs.elki.parallel.variables.SharedDouble;

public class SimplifiedLRDProcessor
extends AbstractDoubleProcessor {
    private DataStore<? extends KNNList> knns;

    public SimplifiedLRDProcessor(DataStore<? extends KNNList> knns) {
        this.knns = knns;
    }

    @Override
    public Instance instantiate(Executor master) {
        return new Instance(master.getInstance(this.output));
    }

    private class Instance
    extends AbstractDoubleProcessor.Instance {
        public Instance(SharedDouble.Instance output) {
            super(output);
        }

        @Override
        public void map(DBIDRef id) {
            KNNList knn = (KNNList)SimplifiedLRDProcessor.this.knns.get(id);
            double lrd = 0.0;
            int size = 0;
            DoubleDBIDListIter n = knn.iter();
            while (n.valid()) {
                if (!DBIDUtil.equal(n, id)) {
                    lrd += n.doubleValue();
                    ++size;
                }
                n.advance();
            }
            this.output.set(lrd > 0.0 ? (double)size / lrd : 0.0);
        }
    }
}

