/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.meta;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.parser.CSVReaderFormat;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.InvertedOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ParseUtil;
import de.lmu.ifi.dbs.elki.utilities.io.TokenizedReader;
import de.lmu.ifi.dbs.elki.utilities.io.Tokenizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.IdentityScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExternalDoubleOutlierScore
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ExternalDoubleOutlierScore.class);
    public static final String COMMENT = "#";
    public static final String ID_PATTERN_DEFAULT = "^ID=";
    private File file;
    private Pattern idpattern;
    private Pattern scorepattern;
    private ScalingFunction scaling;
    private boolean inverted = false;

    public ExternalDoubleOutlierScore(File file, Pattern idpattern, Pattern scorepattern, boolean inverted, ScalingFunction scaling) {
        this.file = file;
        this.idpattern = idpattern;
        this.scorepattern = scorepattern;
        this.inverted = inverted;
        this.scaling = scaling;
    }

    public OutlierResult run(Database database, Relation<?> relation) {
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DoubleMinMax minmax = new DoubleMinMax();
        try (FileInputStream fis = new FileInputStream(this.file);
             InputStream in = FileUtil.tryGzipInput(fis);
             TokenizedReader reader = CSVReaderFormat.DEFAULT_FORMAT.makeReader();){
            Tokenizer tokenizer = reader.getTokenizer();
            CharSequence buf = reader.getBuffer();
            Matcher mi = this.idpattern.matcher(buf);
            Matcher ms = this.scorepattern.matcher(buf);
            reader.reset(in);
            while (reader.nextLineExceptComments()) {
                Integer id = null;
                double score = Double.NaN;
                while (tokenizer.valid()) {
                    mi.region(tokenizer.getStart(), tokenizer.getEnd());
                    ms.region(tokenizer.getStart(), tokenizer.getEnd());
                    boolean mif = mi.find();
                    boolean msf = ms.find();
                    if (mif && msf) {
                        throw new AbortException("ID pattern and score pattern both match value: " + tokenizer.getSubstring());
                    }
                    if (mif) {
                        if (id != null) {
                            throw new AbortException("ID pattern matched twice: previous value " + id + " second value: " + tokenizer.getSubstring());
                        }
                        id = ParseUtil.parseIntBase10(buf, mi.end(), tokenizer.getEnd());
                    }
                    if (msf) {
                        if (!Double.isNaN(score)) {
                            throw new AbortException("Score pattern matched twice: previous value " + score + " second value: " + tokenizer.getSubstring());
                        }
                        score = ParseUtil.parseDouble(buf, ms.end(), tokenizer.getEnd());
                    }
                    tokenizer.advance();
                }
                if (id != null && !Double.isNaN(score)) {
                    scores.putDouble(DBIDUtil.importInteger(id), score);
                    minmax.put(score);
                    continue;
                }
                if (id == null && Double.isNaN(score)) {
                    LOG.warning("Line did not match either ID nor score nor comment: " + reader.getLineNumber());
                    continue;
                }
                throw new AbortException("Line matched only ID or only SCORE patterns: " + reader.getLineNumber());
            }
        }
        catch (IOException e) {
            throw new AbortException("Could not load outlier scores: " + e.getMessage() + " when loading " + this.file, e);
        }
        BasicOutlierScoreMeta meta = this.inverted ? new InvertedOutlierScoreMeta(minmax.getMin(), minmax.getMax()) : new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax());
        MaterializedDoubleRelation scoresult = new MaterializedDoubleRelation("External Outlier", "external-outlier", scores, relation.getDBIDs());
        OutlierResult or = new OutlierResult(meta, scoresult);
        if (this.scaling instanceof OutlierScaling) {
            ((OutlierScaling)this.scaling).prepare(or);
        }
        DoubleMinMax mm = new DoubleMinMax();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double val = scoresult.doubleValue(iditer);
            val = this.scaling.getScaled(val);
            scores.putDouble(iditer, val);
            mm.put(val);
            iditer.advance();
        }
        meta = new BasicOutlierScoreMeta(mm.getMin(), mm.getMax());
        return new OutlierResult(meta, scoresult);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.ANY);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FILE_ID = new OptionID("externaloutlier.file", "The file name containing the (external) outlier scores.");
        public static final OptionID ID_ID = new OptionID("externaloutlier.idpattern", "The pattern to match object ID prefix");
        public static final OptionID SCORE_ID = new OptionID("externaloutlier.scorepattern", "The pattern to match object score prefix");
        public static final OptionID SCALING_ID = new OptionID("externaloutlier.scaling", "Class to use as scaling function.");
        public static final OptionID INVERTED_ID = new OptionID("externaloutlier.inverted", "Flag to signal an inverted outlier score.");
        private File file;
        private Pattern idpattern;
        private Pattern scorepattern;
        private ScalingFunction scaling;
        private boolean inverted = false;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter scalingP;
            Flag inverstedF;
            PatternParameter scoreP;
            PatternParameter idP;
            super.makeOptions(config);
            FileParameter fileP = new FileParameter(FILE_ID, FileParameter.FileType.INPUT_FILE);
            if (config.grab(fileP)) {
                this.file = (File)fileP.getValue();
            }
            if (config.grab(idP = new PatternParameter(ID_ID, ExternalDoubleOutlierScore.ID_PATTERN_DEFAULT))) {
                this.idpattern = (Pattern)idP.getValue();
            }
            if (config.grab(scoreP = new PatternParameter(SCORE_ID))) {
                this.scorepattern = (Pattern)scoreP.getValue();
            }
            if (config.grab(inverstedF = new Flag(INVERTED_ID))) {
                this.inverted = (Boolean)inverstedF.getValue();
            }
            if (config.grab(scalingP = new ObjectParameter(SCALING_ID, (Class<?>)ScalingFunction.class, IdentityScaling.class))) {
                this.scaling = (ScalingFunction)scalingP.instantiateClass(config);
            }
        }

        @Override
        protected ExternalDoubleOutlierScore makeInstance() {
            return new ExternalDoubleOutlierScore(this.file, this.idpattern, this.scorepattern, this.inverted, this.scaling);
        }
    }
}

