/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.meta;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.lof.LOF;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.SubspaceEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.Random;

@Title(value="Feature Bagging for Outlier Detection")
@Reference(authors="A. Lazarevic, V. Kumar", title="Feature Bagging for Outlier Detection", booktitle="Proc. 11th ACM SIGKDD Int. Conf. on Knowledge Discovery in Data Mining", url="https://doi.org/10.1145/1081870.1081891", bibkey="DBLP:conf/kdd/LazarevicK05")
public class FeatureBagging
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(FeatureBagging.class);
    protected int num = 1;
    protected boolean breadth = false;
    private RandomFactory rnd;
    private int k;

    public FeatureBagging(int k, int num, boolean breadth, RandomFactory rnd) {
        this.k = k;
        this.num = num;
        this.breadth = breadth;
        this.rnd = rnd;
    }

    public OutlierResult run(Database database, Relation<NumberVector> relation) {
        FiniteProgress cprog;
        int dbdim = RelationUtil.dimensionality(relation);
        int mindim = dbdim >> 1;
        int maxdim = dbdim - 1;
        Random rand = this.rnd.getSingleThreadedRandom();
        ArrayList<OutlierResult> results = new ArrayList<OutlierResult>(this.num);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("LOF iterations", this.num, LOG) : null;
        for (int i = 0; i < this.num; ++i) {
            long[] dimset = this.randomSubspace(dbdim, mindim, maxdim, rand);
            SubspaceEuclideanDistanceFunction df = new SubspaceEuclideanDistanceFunction(dimset);
            LOF<NumberVector> lof = new LOF<NumberVector>(this.k, df);
            OutlierResult result = lof.run(database, relation);
            results.add(result);
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DoubleMinMax minmax = new DoubleMinMax();
        if (this.breadth) {
            cprog = LOG.isVerbose() ? new FiniteProgress("Combining results", relation.size(), LOG) : null;
            Pair[] IDVectorOntoScoreVector = new Pair[results.size()];
            int i = 0;
            for (OutlierResult r : results) {
                IDVectorOntoScoreVector[i] = new Pair<DBIDArrayMIter, DoubleRelation>(r.getOrdering().order(relation.getDBIDs()).iter(), r.getScores());
                ++i;
            }
            for (i = 0; i < relation.size(); ++i) {
                for (Pair pair : IDVectorOntoScoreVector) {
                    DBIDIter iter = (DBIDIter)pair.first;
                    if (iter.valid()) {
                        double score = ((DoubleRelation)pair.second).doubleValue(iter);
                        if (Double.isNaN(scores.doubleValue(iter))) {
                            scores.putDouble(iter, score);
                            minmax.put(score);
                        }
                        iter.advance();
                        continue;
                    }
                    LOG.warning("Incomplete result: Iterator does not contain |DB| DBIDs");
                }
                LOG.incrementProcessed(cprog);
            }
            LOG.ensureCompleted(cprog);
        } else {
            cprog = LOG.isVerbose() ? new FiniteProgress("Combining results", relation.size(), LOG) : null;
            DBIDIter iter = relation.iterDBIDs();
            while (iter.valid()) {
                double sum = 0.0;
                for (OutlierResult r : results) {
                    double s = r.getScores().doubleValue(iter);
                    if (Double.isNaN(s)) continue;
                    sum += s;
                }
                scores.putDouble(iter, sum);
                minmax.put(sum);
                LOG.incrementProcessed(cprog);
                iter.advance();
            }
            LOG.ensureCompleted(cprog);
        }
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax());
        MaterializedDoubleRelation scoreres = new MaterializedDoubleRelation("Feature bagging", "fb-outlier", scores, relation.getDBIDs());
        return new OutlierResult(meta, scoreres);
    }

    private long[] randomSubspace(int alldim, int mindim, int maxdim, Random rand) {
        long[] dimset = BitsUtil.zero(alldim);
        int[] dims = new int[alldim];
        for (int d = 0; d < alldim; ++d) {
            dims[d] = d;
        }
        int subdim = mindim + rand.nextInt(maxdim - mindim);
        for (int d = 0; d < alldim - subdim; ++d) {
            int s = rand.nextInt(alldim - d);
            BitsUtil.setI(dimset, dims[s]);
            dims[s] = dims[alldim - d - 1];
        }
        return dimset;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID NUM_ID = new OptionID("fbagging.num", "The number of instances to use in the ensemble.");
        public static final OptionID BREADTH_ID = new OptionID("fbagging.breadth", "Use the breadth first combinations instead of the cumulative sum approach");
        public static final OptionID SEED_ID = new OptionID("fbagging.seed", "Specify a particular random seed.");
        protected int k = 2;
        protected int num = 1;
        protected boolean breadth = false;
        protected RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter rndP;
            Flag breadthF;
            IntParameter numP;
            super.makeOptions(config);
            IntParameter pK = (IntParameter)new IntParameter(LOF.Parameterizer.K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_THAN_ONE_INT);
            if (config.grab(pK)) {
                this.k = (Integer)pK.getValue();
            }
            if (config.grab(numP = (IntParameter)new IntParameter(NUM_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.num = (Integer)numP.getValue();
            }
            if (config.grab(breadthF = new Flag(BREADTH_ID))) {
                this.breadth = (Boolean)breadthF.getValue();
            }
            if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected FeatureBagging makeInstance() {
            return new FeatureBagging(this.k, this.num, this.breadth, this.rnd);
        }
    }
}

