/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.meta;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.Algorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScaling;
import java.util.ArrayList;

public class RescaleMetaOutlierAlgorithm
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(RescaleMetaOutlierAlgorithm.class);
    public static final OptionID SCALING_ID = new OptionID("metaoutlier.scaling", "Class to use as scaling function.");
    private Algorithm algorithm;
    private ScalingFunction scaling;

    public RescaleMetaOutlierAlgorithm(Algorithm algorithm, ScalingFunction scaling) {
        this.algorithm = algorithm;
        this.scaling = scaling;
    }

    @Override
    public OutlierResult run(Database database) {
        Result innerresult = this.algorithm.run(database);
        OutlierResult or = this.getOutlierResult(database.getHierarchy(), innerresult);
        DoubleRelation scores = or.getScores();
        if (this.scaling instanceof OutlierScaling) {
            ((OutlierScaling)this.scaling).prepare(or);
        }
        WritableDoubleDataStore scaledscores = DataStoreUtil.makeDoubleStorage(scores.getDBIDs(), 6);
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iditer = scores.iterDBIDs();
        while (iditer.valid()) {
            double val = this.scaling.getScaled(scores.doubleValue(iditer));
            scaledscores.putDouble(iditer, val);
            minmax.put(val);
            iditer.advance();
        }
        BasicOutlierScoreMeta meta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), this.scaling.getMin(), this.scaling.getMax());
        MaterializedDoubleRelation scoresult = new MaterializedDoubleRelation("Scaled Outlier", "scaled-outlier", scaledscores, scores.getDBIDs());
        OutlierResult result = new OutlierResult(meta, scoresult);
        result.addChildResult(innerresult);
        return result;
    }

    private OutlierResult getOutlierResult(ResultHierarchy hier, Result result) {
        ArrayList<OutlierResult> ors = ResultUtil.filterResults(hier, result, OutlierResult.class);
        if (!ors.isEmpty()) {
            return (OutlierResult)ors.get(0);
        }
        throw new IllegalStateException("Comparison algorithm expected at least one outlier result.");
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return this.algorithm.getInputTypeRestriction();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        private Algorithm algorithm;
        private ScalingFunction scaling;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter scalingP;
            super.makeOptions(config);
            ObjectParameter algP = new ObjectParameter(AbstractAlgorithm.ALGORITHM_ID, OutlierAlgorithm.class);
            if (config.grab(algP)) {
                this.algorithm = (Algorithm)algP.instantiateClass(config);
            }
            if (config.grab(scalingP = new ObjectParameter(SCALING_ID, ScalingFunction.class))) {
                this.scaling = (ScalingFunction)scalingP.instantiateClass(config);
            }
        }

        @Override
        protected RescaleMetaOutlierAlgorithm makeInstance() {
            return new RescaleMetaOutlierAlgorithm(this.algorithm, this.scaling);
        }
    }
}

