/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.meta;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.Algorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.CombinedTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.ensemble.EnsembleVoting;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ChainedParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimpleOutlierEnsemble
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(SimpleOutlierEnsemble.class);
    private List<OutlierAlgorithm> algorithms;
    private EnsembleVoting voting;

    public SimpleOutlierEnsemble(List<OutlierAlgorithm> algorithms, EnsembleVoting voting) {
        this.algorithms = algorithms;
        this.voting = voting;
    }

    @Override
    public OutlierResult run(Database database) throws IllegalStateException {
        int num = this.algorithms.size();
        HashSetModifiableDBIDs ids = DBIDUtil.newHashSet();
        ArrayList<OutlierResult> results = new ArrayList<OutlierResult>(num);
        FiniteProgress prog = LOG.isVerbose() ? new FiniteProgress("Inner outlier algorithms", num, LOG) : null;
        for (Algorithm algorithm : this.algorithms) {
            Result res = algorithm.run(database);
            List<OutlierResult> ors = OutlierResult.getOutlierResults(res);
            for (OutlierResult or : ors) {
                results.add(or);
                ids.addDBIDs(or.getScores().getDBIDs());
            }
            LOG.incrementProcessed(prog);
        }
        LOG.ensureCompleted(prog);
        WritableDoubleDataStore sumscore = DataStoreUtil.makeDoubleStorage(ids, 4);
        DoubleMinMax minmax = new DoubleMinMax();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Combining results", ids.size(), LOG) : null;
        DBIDMIter id = ids.iter();
        while (id.valid()) {
            double[] scores = new double[num];
            int i = 0;
            for (OutlierResult r : results) {
                double score = r.getScores().doubleValue(id);
                if (!Double.isNaN(score)) {
                    scores[i] = score;
                    ++i;
                    continue;
                }
                LOG.warning("DBID " + id + " was not given a score by result " + r);
            }
            if (i > 0) {
                if (i < scores.length) {
                    scores = Arrays.copyOf(scores, i);
                }
                double combined = this.voting.combine(scores);
                sumscore.putDouble(id, combined);
                minmax.put(combined);
            } else {
                LOG.warning("DBID " + id + " was not given any score at all.");
            }
            LOG.incrementProcessed(finiteProgress);
            id.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax());
        MaterializedDoubleRelation scores = new MaterializedDoubleRelation("Simple Outlier Ensemble", "ensemble-outlier", sumscore, ids);
        return new OutlierResult(basicOutlierScoreMeta, scores);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        TypeInformation[] trs = new TypeInformation[this.algorithms.size()];
        for (int i = 0; i < trs.length; ++i) {
            trs[i] = this.algorithms.get(i).getInputTypeRestriction()[0];
        }
        return TypeUtil.array(new CombinedTypeInformation(trs));
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID VOTING_ID = new OptionID("ensemble.voting", "Voting strategy to use in the ensemble.");
        private List<OutlierAlgorithm> algorithms;
        private EnsembleVoting voting;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter votingP;
            super.makeOptions(config);
            ObjectListParameter algP = new ObjectListParameter(AbstractAlgorithm.ALGORITHM_ID, OutlierAlgorithm.class);
            if (config.grab(algP)) {
                ListParameterization subconfig = new ListParameterization();
                ChainedParameterization chain = new ChainedParameterization(subconfig, config);
                chain.errorsTo(config);
                this.algorithms = algP.instantiateClasses(chain);
                subconfig.logAndClearReportedErrors();
            }
            if (config.grab(votingP = new ObjectParameter(VOTING_ID, EnsembleVoting.class))) {
                this.voting = (EnsembleVoting)votingP.instantiateClass(config);
            }
        }

        @Override
        protected SimpleOutlierEnsemble makeInstance() {
            return new SimpleOutlierEnsemble(this.algorithms, this.voting);
        }
    }
}

