/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.ProxyView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import net.jafama.FastMath;

@Title(value="GLS-Backward Search")
@Reference(authors="F. Chen, C.-T. Lu, A. P. Boedihardjo", title="GLS-SOD: A Generalized Local Statistical Approach for Spatial Outlier Detection", booktitle="Proc. 16th ACM SIGKDD Int. Conf. Knowledge Discovery and Data Mining", url="https://doi.org/10.1145/1835804.1835939", bibkey="DBLP:conf/kdd/ChenLB10")
public class CTLuGLSBackwardSearchAlgorithm<V extends NumberVector>
extends AbstractDistanceBasedAlgorithm<V, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(CTLuGLSBackwardSearchAlgorithm.class);
    private double alpha;
    private int k;

    public CTLuGLSBackwardSearchAlgorithm(DistanceFunction<? super V> distanceFunction, int k, double alpha) {
        super(distanceFunction);
        this.alpha = alpha;
        this.k = k;
    }

    public OutlierResult run(Database database, Relation<V> relationx, Relation<? extends NumberVector> relationy) {
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relationx.getDBIDs(), 4);
        DoubleMinMax mm = new DoubleMinMax(0.0, 0.0);
        HashSetModifiableDBIDs idview = DBIDUtil.newHashSet(relationx.getDBIDs());
        ProxyView<V> proxy = new ProxyView<V>(idview, relationx);
        double phialpha = NormalDistribution.standardNormalQuantile(1.0 - this.alpha * 0.5);
        while (true) {
            Pair<DBIDVar, Double> candidate = this.singleIteration(proxy, relationy);
            if ((Double)candidate.second < phialpha) break;
            scores.putDouble((DBIDRef)candidate.first, (Double)candidate.second);
            if (!Double.isNaN((Double)candidate.second)) {
                mm.put((Double)candidate.second);
            }
            idview.remove((DBIDRef)candidate.first);
        }
        DBIDMIter iter = idview.iter();
        while (iter.valid()) {
            scores.putDouble(iter, 0.0);
            iter.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("GLSSODBackward", "GLSSODbackward-outlier", scores, relationx.getDBIDs());
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(mm.getMin(), mm.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    private Pair<DBIDVar, Double> singleIteration(Relation<V> relationx, Relation<? extends NumberVector> relationy) {
        int dim = RelationUtil.dimensionality(relationx);
        int dimy = RelationUtil.dimensionality(relationy);
        assert (dim == 2);
        KNNQuery<V> knnQuery = QueryUtil.getKNNQuery(relationx, this.getDistanceFunction(), this.k + 1);
        ArrayModifiableDBIDs ids = DBIDUtil.newArray(relationx.getDBIDs());
        ids.sort();
        double[][] X = new double[ids.size()][6];
        double[][] F = new double[ids.size()][ids.size()];
        double[][] Y = new double[ids.size()][dimy];
        int i = 0;
        DBIDArrayMIter id = ids.iter();
        while (id.valid()) {
            NumberVector vec = (NumberVector)relationx.get(id);
            double la = vec.doubleValue(0);
            double lo = vec.doubleValue(1);
            X[i][0] = 1.0;
            X[i][1] = la;
            X[i][2] = lo;
            X[i][3] = la * lo;
            X[i][4] = la * la;
            X[i][5] = lo * lo;
            NumberVector vecy = relationy.get(id);
            for (int d = 0; d < dimy; ++d) {
                double idy;
                Y[i][d] = idy = vecy.doubleValue(d);
            }
            KNNList neighbors = knnQuery.getKNNForDBID(id, this.k + 1);
            ArrayModifiableDBIDs neighborhood = DBIDUtil.newArray(neighbors.size());
            DoubleDBIDListIter neighbor = neighbors.iter();
            while (neighbor.valid()) {
                if (!DBIDUtil.equal(id, neighbor)) {
                    neighborhood.add(neighbor);
                }
                neighbor.advance();
            }
            F[i][i] = 1.0;
            int nweight = -1 / neighborhood.size();
            DBIDMIter iter = neighborhood.iter();
            while (iter.valid()) {
                int pos = ids.binarySearch(iter);
                assert (pos >= 0);
                F[pos][i] = nweight;
                iter.advance();
            }
            id.advance();
            ++i;
        }
        double[][] common = VMath.times(VMath.transposeTimesTranspose(X, F), F);
        double[][] b = VMath.times(VMath.inverse(VMath.times(common, X)), VMath.times(common, Y));
        double[][] sigmaMat = VMath.times(F, VMath.minusEquals(VMath.times(X, b), VMath.times(F, Y)));
        double sigma_sum_square = VMath.normF(sigmaMat) / (double)(relationx.size() - 6 - 1);
        double norm = 1.0 / FastMath.sqrt(sigma_sum_square);
        double[][] E = VMath.timesEquals(VMath.times(F, VMath.minus(Y, VMath.times(X, b))), norm);
        DBIDVar worstid = DBIDUtil.newVar();
        double worstscore = Double.NEGATIVE_INFINITY;
        int i2 = 0;
        DBIDArrayMIter id2 = ids.iter();
        while (id2.valid()) {
            double err = VMath.squareSum(VMath.getRow(E, i2));
            if (err > worstscore) {
                worstscore = err;
                worstid.set(id2);
            }
            id2.advance();
            ++i2;
        }
        return new Pair<DBIDVar, Double>(worstid, FastMath.sqrt(worstscore));
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<V> {
        public static final OptionID ALPHA_ID = new OptionID("glsbs.alpha", "Significance niveau");
        public static final OptionID K_ID = new OptionID("glsbs.k", "k nearest neighbors to use");
        private double alpha;
        private int k;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            this.getParameterAlpha(config);
            this.getParameterK(config);
        }

        @Override
        protected CTLuGLSBackwardSearchAlgorithm<V> makeInstance() {
            return new CTLuGLSBackwardSearchAlgorithm(this.distanceFunction, this.k, this.alpha);
        }

        protected void getParameterAlpha(Parameterization config) {
            DoubleParameter param = new DoubleParameter(ALPHA_ID);
            if (config.grab(param)) {
                this.alpha = (Double)param.getValue();
            }
        }

        protected void getParameterK(Parameterization config) {
            IntParameter param = new IntParameter(K_ID);
            if (config.grab(param)) {
                this.k = (Integer)param.getValue();
            }
        }
    }
}

