/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Centroid;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="C.-T. Lu, D. Chen, Y. Kou", title="Detecting Spatial Outliers with Multiple Attributes", booktitle="Proc. 15th IEEE Int. Conf. Tools with Artificial Intelligence (TAI 2003)", url="https://doi.org/10.1109/TAI.2003.1250179", bibkey="DBLP:conf/ictai/LuCK03")
public class CTLuMeanMultipleAttributes<N, O extends NumberVector>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuMeanMultipleAttributes.class);

    public CTLuMeanMultipleAttributes(NeighborSetPredicate.Factory<N> npredf) {
        super(npredf);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public OutlierResult run(Database database, Relation<N> spatial, Relation<O> attributes) {
        if (LOG.isDebugging()) {
            LOG.debug("Dimensionality: " + RelationUtil.dimensionality(attributes));
        }
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, spatial);
        CovarianceMatrix covmaker = new CovarianceMatrix(RelationUtil.dimensionality(attributes));
        WritableDataStore<double[]> deltas = DataStoreUtil.makeStorage(attributes.getDBIDs(), 1, double[].class);
        DBIDIter iditer = attributes.iterDBIDs();
        while (iditer.valid()) {
            NumberVector obj = (NumberVector)attributes.get(iditer);
            DBIDs neighbors = npred.getNeighborDBIDs(iditer);
            double[] mean = Centroid.make(attributes, neighbors).getArrayRef();
            double[] delta = VMath.minusEquals(obj.toArray(), mean);
            deltas.put(iditer, delta);
            covmaker.put(delta);
            iditer.advance();
        }
        double[] mean = covmaker.getMeanVector();
        double[][] cmati = VMath.inverse(covmaker.destroyToSampleMatrix());
        DoubleMinMax minmax = new DoubleMinMax();
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(attributes.getDBIDs(), 4);
        DBIDIter iditer2 = attributes.iterDBIDs();
        while (iditer2.valid()) {
            double[] v = VMath.minusEquals((double[])deltas.get(iditer2), mean);
            double score = VMath.transposeTimesTimes(v, cmati, v);
            minmax.put(score);
            scores.putDouble(iditer2, score);
            iditer2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("mean multiple attributes spatial outlier", "mean-multipleattributes-outlier", scores, attributes.getDBIDs());
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult or = new OutlierResult(scoreMeta, scoreResult);
        or.addChildResult(npred);
        return or;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD);
    }

    public static class Parameterizer<N, O extends NumberVector>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        @Override
        protected CTLuMeanMultipleAttributes<N, O> makeInstance() {
            return new CTLuMeanMultipleAttributes(this.npredf);
        }
    }
}

