/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Median Algorithm for Spatial Outlier Detection")
@Reference(authors="C.-T. Lu, D. Chen, Y. Kou", title="Algorithms for Spatial Outlier Detection", booktitle="Proc. 3rd IEEE International Conference on Data Mining", url="https://doi.org/10.1109/ICDM.2003.1250986", bibkey="DBLP:conf/icdm/LuCK03")
public class CTLuMedianAlgorithm<N>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuMedianAlgorithm.class);

    public CTLuMedianAlgorithm(NeighborSetPredicate.Factory<N> npredf) {
        super(npredf);
    }

    public OutlierResult run(Database database, Relation<N> nrel, Relation<? extends NumberVector> relation) {
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, nrel);
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        MeanVariance mv = new MeanVariance();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            DBIDs neighbors = npred.getNeighborDBIDs(iditer);
            double[] fi = new double[neighbors.size()];
            int c = 0;
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal(iditer, iter)) {
                    fi[c] = relation.get(iter).doubleValue(0);
                    ++c;
                }
                iter.advance();
            }
            double median = c > 0 ? QuickSelect.median(fi, 0, c) : relation.get(iditer).doubleValue(0);
            double h = relation.get(iditer).doubleValue(0) - median;
            scores.putDouble(iditer, h);
            mv.put(h);
            iditer.advance();
        }
        double mean = mv.getMean();
        double stddev = mv.getNaiveStddev();
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            double score = Math.abs((scores.doubleValue(iditer2) - mean) / stddev);
            minmax.put(score);
            scores.putDouble(iditer2, score);
            iditer2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("MO", "Median-outlier", scores, relation.getDBIDs());
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult or = new OutlierResult(scoreMeta, scoreResult);
        or.addChildResult(npred);
        return or;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    public static class Parameterizer<N>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        @Override
        protected CTLuMedianAlgorithm<N> makeInstance() {
            return new CTLuMedianAlgorithm(this.npredf);
        }
    }
}

