/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Moran Scatterplot Outlier")
@Description(value="Spatial Outlier detection based on the standardized deviation from the local means.")
@Reference(authors="S. Shekhar, C.-T. Lu, P. Zhang", title="A Unified Approach to Detecting Spatial Outliers", booktitle="GeoInformatica 7-2, 2003", url="https://doi.org/10.1023/A:1023455925009", bibkey="DBLP:journals/geoinformatica/ShekharLZ03")
public class CTLuMoranScatterplotOutlier<N>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuMoranScatterplotOutlier.class);

    public CTLuMoranScatterplotOutlier(NeighborSetPredicate.Factory<N> npredf) {
        super(npredf);
    }

    public OutlierResult run(Database database, Relation<N> nrel, Relation<? extends NumberVector> relation) {
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, nrel);
        MeanVariance globalmv = new MeanVariance();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            globalmv.put(relation.get(iditer).doubleValue(0));
            iditer.advance();
        }
        DoubleMinMax minmax = new DoubleMinMax();
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            double globalZ = (relation.get(iditer2).doubleValue(0) - globalmv.getMean()) / globalmv.getNaiveStddev();
            Mean localm = new Mean();
            DBIDIter iter = npred.getNeighborDBIDs(iditer2).iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal(iditer2, iter)) {
                    localm.put((relation.get(iter).doubleValue(0) - globalmv.getMean()) / globalmv.getNaiveStddev());
                }
                iter.advance();
            }
            double localZ = localm.getCount() > 0.0 ? localm.getMean() : globalZ;
            double score = Math.max(-globalZ * localZ, 0.0);
            minmax.put(score);
            scores.putDouble(iditer2, score);
            iditer2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("MoranOutlier", "Moran Scatterplot Outlier", scores, relation.getDBIDs());
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult or = new OutlierResult(scoreMeta, scoreResult);
        or.addChildResult(npred);
        return or;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<N>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        @Override
        protected CTLuMoranScatterplotOutlier<N> makeInstance() {
            return new CTLuMoranScatterplotOutlier(this.npredf);
        }
    }
}

