/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.ParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import net.jafama.FastMath;

@Title(value="Random Walk on Exhaustive Combination")
@Description(value="Spatial Outlier Detection using Random Walk on Exhaustive Combination")
@Reference(authors="X. Liu, C.-T. Lu, F. Chen", title="Spatial outlier detection: random walk based approaches", booktitle="Proc. SIGSPATIAL Int. Conf. Advances in Geographic Information Systems", url="https://doi.org/10.1145/1869790.1869841", bibkey="DBLP:conf/gis/LiuLC10")
public class CTLuRandomWalkEC<P>
extends AbstractDistanceBasedAlgorithm<P, OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(CTLuRandomWalkEC.class);
    private double alpha;
    private double c;
    private int k;

    public CTLuRandomWalkEC(DistanceFunction<? super P> distanceFunction, double alpha, double c, int k) {
        super(distanceFunction);
        this.alpha = alpha;
        this.c = c;
        this.k = k;
    }

    public OutlierResult run(Relation<P> spatial, Relation<? extends NumberVector> relation) {
        DistanceQuery<P> distFunc = this.getDistanceFunction().instantiate(spatial);
        WritableDataStore<double[]> similarityVectors = DataStoreUtil.makeStorage(spatial.getDBIDs(), 1, double[].class);
        WritableDataStore<DBIDs> neighbors = DataStoreUtil.makeStorage(spatial.getDBIDs(), 1, DBIDs.class);
        ArrayDBIDs ids = DBIDUtil.ensureArray(relation.getDBIDs());
        double[][] E = new double[ids.size()][ids.size()];
        KNNHeap heap = DBIDUtil.newHeap(this.k);
        int i = 0;
        DBIDArrayIter id = ids.iter();
        while (id.valid()) {
            double val = relation.get(id).doubleValue(0);
            assert (heap.size() == 0);
            int j = 0;
            DBIDArrayIter n = ids.iter();
            while (n.valid()) {
                if (i != j) {
                    double e;
                    double distance = distFunc.distance((DBIDRef)id, (DBIDRef)n);
                    heap.insert(distance, n);
                    if (distance == 0.0) {
                        LOG.warning("Zero distances are not supported - skipping: " + DBIDUtil.toString(id) + " " + DBIDUtil.toString(n));
                        e = 0.0;
                    } else {
                        double diff = Math.abs(val - relation.get(n).doubleValue(0));
                        double exp = FastMath.exp(FastMath.pow(diff, this.alpha));
                        e = exp / distance;
                    }
                    E[j][i] = e;
                }
                n.advance();
                ++j;
            }
            ArrayModifiableDBIDs nids = DBIDUtil.newArray(heap.size());
            DoubleDBIDListIter it = heap.unorderedIterator();
            while (it.valid()) {
                nids.add(it);
                it.advance();
            }
            neighbors.put(id, nids);
            id.advance();
            ++i;
        }
        for (i = 0; i < E[0].length; ++i) {
            int j;
            double sum = 0.0;
            for (j = 0; j < E.length; ++j) {
                sum += E[j][i];
            }
            if (sum == 0.0) {
                sum = 1.0;
            }
            for (j = 0; j < E.length; ++j) {
                E[j][i] = -this.c * E[j][i] / sum;
            }
        }
        assert (E.length == E[0].length);
        for (int col = 0; col < E[0].length; ++col) {
            assert (E[col][col] == 0.0);
            E[col][col] = 1.0;
        }
        E = VMath.timesEquals(VMath.inverse(E), 1.0 - this.c);
        i = 0;
        id = ids.iter();
        while (id.valid()) {
            double[] sim = VMath.getCol(E, i);
            similarityVectors.put(id, sim);
            id.advance();
            ++i;
        }
        E = null;
        DoubleMinMax minmax = new DoubleMinMax();
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(spatial.getDBIDs(), 4);
        DBIDArrayIter id2 = ids.iter();
        while (id2.valid()) {
            double gmean = 1.0;
            int cnt = 0;
            DBIDIter iter = ((DBIDs)neighbors.get(id2)).iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal(id2, iter)) {
                    double sim = VMath.angle((double[])similarityVectors.get(id2), (double[])similarityVectors.get(iter));
                    gmean *= sim;
                    ++cnt;
                }
                iter.advance();
            }
            double score = FastMath.pow(gmean, 1.0 / (double)cnt);
            minmax.put(score);
            scores.putDouble(id2, score);
            id2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("randomwalkec", "RandomWalkEC", scores, relation.getDBIDs());
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        return new OutlierResult(scoreMeta, scoreResult);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<N>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<N> {
        public static final OptionID K_ID = new OptionID("randomwalkec.k", "Number of nearest neighbors to use.");
        public static final OptionID ALPHA_ID = new OptionID("randomwalkec.alpha", "Scaling exponent for value differences.");
        public static final OptionID C_ID = new OptionID("randomwalkec.c", "The damping parameter c.");
        double alpha = 0.5;
        double c = 0.9;
        int k;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            this.configK(config);
            this.configAlpha(config);
            this.configC(config);
        }

        protected void configK(Parameterization config) {
            IntParameter param = (IntParameter)new IntParameter(K_ID).addConstraint((ParameterConstraint)CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (config.grab(param)) {
                this.k = (Integer)param.getValue();
            }
        }

        protected void configAlpha(Parameterization config) {
            DoubleParameter param = new DoubleParameter(ALPHA_ID, 0.5);
            if (config.grab(param)) {
                this.alpha = (Double)param.getValue();
            }
        }

        protected void configC(Parameterization config) {
            DoubleParameter param = new DoubleParameter(C_ID);
            if (config.grab(param)) {
                this.c = (Double)param.getValue();
            }
        }

        @Override
        protected CTLuRandomWalkEC<N> makeInstance() {
            return new CTLuRandomWalkEC(this.distanceFunction, this.alpha, this.c, this.k);
        }
    }
}

