/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Scatterplot Spatial Outlier")
@Description(value="Spatial Outlier Detection Algorithm using linear regression of attributes and the mean of their neighbors.")
@Reference(authors="S. Shekhar, C.-T. Lu, P. Zhang", title="A Unified Approach to Detecting Spatial Outliers", booktitle="GeoInformatica 7-2, 2003", url="https://doi.org/10.1023/A:1023455925009", bibkey="DBLP:journals/geoinformatica/ShekharLZ03")
public class CTLuScatterplotOutlier<N>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuScatterplotOutlier.class);

    public CTLuScatterplotOutlier(NeighborSetPredicate.Factory<N> npredf) {
        super(npredf);
    }

    public OutlierResult run(Database database, Relation<N> nrel, Relation<? extends NumberVector> relation) {
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, nrel);
        WritableDoubleDataStore means = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 1);
        CovarianceMatrix covm = new CovarianceMatrix(2);
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            double local = relation.get(iditer).doubleValue(0);
            Mean mean = new Mean();
            DBIDs neighbors = npred.getNeighborDBIDs(iditer);
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal(iditer, iter)) {
                    mean.put(relation.get(iter).doubleValue(0));
                }
                iter.advance();
            }
            double m = mean.getCount() > 0.0 ? mean.getMean() : local;
            means.putDouble(iditer, m);
            covm.put(new double[]{local, m});
            iditer.advance();
        }
        double[] meanv = covm.getMeanVector();
        double[][] fmat = covm.destroyToSampleMatrix();
        double covxx = fmat[0][0];
        double covxy = fmat[0][1];
        double slope = covxy / covxx;
        double inter = meanv[1] - slope * meanv[0];
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        MeanVariance mv = new MeanVariance();
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            double y_i = relation.get(iditer2).doubleValue(0);
            double e = means.doubleValue(iditer2) - (slope * y_i + inter);
            scores.putDouble(iditer2, e);
            mv.put(e);
            iditer2.advance();
        }
        DoubleMinMax minmax = new DoubleMinMax();
        double mean = mv.getMean();
        double variance = mv.getNaiveStddev();
        DBIDIter iditer3 = relation.iterDBIDs();
        while (iditer3.valid()) {
            double score = Math.abs((scores.doubleValue(iditer3) - mean) / variance);
            minmax.put(score);
            scores.putDouble(iditer3, score);
            iditer3.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("SPO", "Scatterplot-Outlier", scores, relation.getDBIDs());
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult or = new OutlierResult(scoreMeta, scoreResult);
        or.addChildResult(npred);
        return or;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    public static class Parameterizer<N>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        @Override
        protected CTLuScatterplotOutlier<N> makeInstance() {
            return new CTLuScatterplotOutlier(this.npredf);
        }
    }
}

