/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Z-Test Outlier Detection")
@Description(value="Outliers are detected by their z-deviation from the local mean.")
@Reference(authors="S. Shekhar, C.-T. Lu, P. Zhang", title="A Unified Approach to Detecting Spatial Outliers", booktitle="GeoInformatica 7-2, 2003", url="https://doi.org/10.1023/A:1023455925009", bibkey="DBLP:journals/geoinformatica/ShekharLZ03")
public class CTLuZTestOutlier<N>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuZTestOutlier.class);

    public CTLuZTestOutlier(NeighborSetPredicate.Factory<N> npredf) {
        super(npredf);
    }

    public OutlierResult run(Database database, Relation<N> nrel, Relation<? extends NumberVector> relation) {
        NeighborSetPredicate npred = this.getNeighborSetPredicateFactory().instantiate(database, nrel);
        WritableDoubleDataStore scores = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 4);
        MeanVariance zmv = new MeanVariance();
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            DBIDs neighbors = npred.getNeighborDBIDs(iditer);
            Mean localmean = new Mean();
            DBIDIter iter = neighbors.iter();
            while (iter.valid()) {
                if (!DBIDUtil.equal(iditer, iter)) {
                    localmean.put(relation.get(iter).doubleValue(0));
                }
                iter.advance();
            }
            double localdiff = localmean.getCount() > 0.0 ? relation.get(iditer).doubleValue(0) - localmean.getMean() : 0.0;
            scores.putDouble(iditer, localdiff);
            zmv.put(localdiff);
            iditer.advance();
        }
        DoubleMinMax minmax = new DoubleMinMax();
        DBIDIter iditer2 = relation.iterDBIDs();
        while (iditer2.valid()) {
            double score = Math.abs(scores.doubleValue(iditer2) - zmv.getMean()) / zmv.getSampleStddev();
            minmax.put(score);
            scores.putDouble(iditer2, score);
            iditer2.advance();
        }
        MaterializedDoubleRelation scoreResult = new MaterializedDoubleRelation("ZTest", "Z Test score", scores, relation.getDBIDs());
        BasicOutlierScoreMeta scoreMeta = new BasicOutlierScoreMeta(minmax.getMin(), minmax.getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult or = new OutlierResult(scoreMeta, scoreResult);
        or.addChildResult(npred);
        return or;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    public static class Parameterizer<N>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        @Override
        protected CTLuZTestOutlier<N> makeInstance() {
            return new CTLuZTestOutlier(this.npredf);
        }
    }
}

